/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.ioopcallbacks;

import java.util.List;
import org.apache.asterix.common.ioopcallbacks.AbstractLSMIOOperationCallback;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexDiskComponent;

public class LSMInvertedIndexIOOperationCallback
extends AbstractLSMIOOperationCallback {
    public void afterOperation(LSMOperationType opType, List<ILSMComponent> oldComponents, ILSMDiskComponent newComponent) throws HyracksDataException {
        if (newComponent != null) {
            LSMInvertedIndexDiskComponent invIndexComponent = (LSMInvertedIndexDiskComponent)newComponent;
            this.putLSNIntoMetadata((ILSMDiskComponent)invIndexComponent, oldComponents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getComponentLSN(List<? extends ILSMComponent> diskComponents) throws HyracksDataException {
        if (diskComponents == null) {
            LSMInvertedIndexIOOperationCallback lSMInvertedIndexIOOperationCallback = this;
            synchronized (lSMInvertedIndexIOOperationCallback) {
                long lsn = this.mutableLastLSNs[this.readIndex];
                return lsn;
            }
        }
        long maxLSN = -1L;
        for (ILSMComponent iLSMComponent : diskComponents) {
            LSMInvertedIndexDiskComponent invIndexComponent = (LSMInvertedIndexDiskComponent)iLSMComponent;
            maxLSN = Math.max(AbstractLSMIOOperationCallback.getTreeIndexLSN((ITreeIndex)invIndexComponent.getDeletedKeysBTree()), maxLSN);
        }
        return maxLSN;
    }

    @Override
    public long getComponentFileLSNOffset(ILSMDiskComponent diskComponent, String diskComponentFilePath) throws HyracksDataException {
        if (diskComponentFilePath.endsWith("d")) {
            LSMInvertedIndexDiskComponent invIndexComponent = (LSMInvertedIndexDiskComponent)diskComponent;
            IMetadataPageManager metadataPageManager = (IMetadataPageManager)invIndexComponent.getDeletedKeysBTree().getPageManager();
            return metadataPageManager.getFileOffset(metadataPageManager.createMetadataFrame(), (IValueReference)LSN_KEY);
        }
        return -1L;
    }
}

