/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.config.StorageProperties;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.impls.MultitenantVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.impls.VirtualBufferCache;
import org.apache.hyracks.storage.common.IResourceMemoryManager;
import org.apache.hyracks.storage.common.buffercache.ICacheMemoryAllocator;
import org.apache.hyracks.storage.common.buffercache.ResourceHeapBufferAllocator;

public class DatasetVirtualBufferCaches {
    private final int datasetID;
    private final StorageProperties storageProperties;
    private final int firstAvilableUserDatasetID;
    private final int numPartitions;
    private final Map<Integer, List<IVirtualBufferCache>> ioDeviceVirtualBufferCaches = new HashMap<Integer, List<IVirtualBufferCache>>();

    public DatasetVirtualBufferCaches(int datasetID, StorageProperties storageProperties, int firstAvilableUserDatasetID, int numPartitions) {
        this.datasetID = datasetID;
        this.storageProperties = storageProperties;
        this.firstAvilableUserDatasetID = firstAvilableUserDatasetID;
        this.numPartitions = numPartitions;
    }

    public List<IVirtualBufferCache> initializeVirtualBufferCaches(IResourceMemoryManager memoryManager, int ioDeviceNum) {
        int numPages = this.datasetID < this.firstAvilableUserDatasetID ? this.storageProperties.getMetadataMemoryComponentNumPages() : this.storageProperties.getMemoryComponentNumPages();
        ArrayList<IVirtualBufferCache> vbcs = new ArrayList<IVirtualBufferCache>();
        for (int i = 0; i < this.storageProperties.getMemoryComponentsNum(); ++i) {
            MultitenantVirtualBufferCache vbc = new MultitenantVirtualBufferCache((IVirtualBufferCache)new VirtualBufferCache((ICacheMemoryAllocator)new ResourceHeapBufferAllocator(memoryManager, Integer.toString(this.datasetID)), this.storageProperties.getMemoryComponentPageSize(), numPages / this.storageProperties.getMemoryComponentsNum() / this.numPartitions));
            vbcs.add((IVirtualBufferCache)vbc);
        }
        this.ioDeviceVirtualBufferCaches.put(ioDeviceNum, vbcs);
        return vbcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IVirtualBufferCache> getVirtualBufferCaches(IResourceMemoryManager memoryManager, int ioDeviceNum) {
        Map<Integer, List<IVirtualBufferCache>> map = this.ioDeviceVirtualBufferCaches;
        synchronized (map) {
            List<IVirtualBufferCache> vbcs = this.ioDeviceVirtualBufferCaches.get(ioDeviceNum);
            if (vbcs == null) {
                vbcs = this.initializeVirtualBufferCaches(memoryManager, ioDeviceNum);
            }
            return vbcs;
        }
    }

    public long getTotalSize() {
        int numPages = this.datasetID < this.firstAvilableUserDatasetID ? this.storageProperties.getMetadataMemoryComponentNumPages() : this.storageProperties.getMemoryComponentNumPages();
        return (long)this.storageProperties.getMemoryComponentPageSize() * (long)numPages;
    }
}

