/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.meta;

import org.apache.hyracks.algebricks.runtime.base.AlgebricksPipeline;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntime;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class PipelineAssembler {
    private final RecordDescriptor pipelineInputRecordDescriptor;
    private final RecordDescriptor pipelineOutputRecordDescriptor;
    private final int inputArity;
    private final int outputArity;
    private final AlgebricksPipeline pipeline;

    public PipelineAssembler(AlgebricksPipeline pipeline, int inputArity, int outputArity, RecordDescriptor pipelineInputRecordDescriptor, RecordDescriptor pipelineOutputRecordDescriptor) {
        this.pipeline = pipeline;
        this.pipelineInputRecordDescriptor = pipelineInputRecordDescriptor;
        this.pipelineOutputRecordDescriptor = pipelineOutputRecordDescriptor;
        this.inputArity = inputArity;
        this.outputArity = outputArity;
    }

    public IFrameWriter assemblePipeline(IFrameWriter writer, IHyracksTaskContext ctx) throws HyracksDataException {
        IFrameWriter start = writer;
        for (int i = this.pipeline.getRuntimeFactories().length - 1; i >= 0; --i) {
            IPushRuntime newRuntime = this.pipeline.getRuntimeFactories()[i].createPushRuntime(ctx);
            if (i == this.pipeline.getRuntimeFactories().length - 1) {
                if (this.outputArity == 1) {
                    newRuntime.setFrameWriter(0, start, this.pipelineOutputRecordDescriptor);
                }
            } else {
                newRuntime.setFrameWriter(0, start, this.pipeline.getRecordDescriptors()[i]);
            }
            if (i > 0) {
                newRuntime.setInputRecordDescriptor(0, this.pipeline.getRecordDescriptors()[i - 1]);
            } else if (this.inputArity > 0) {
                newRuntime.setInputRecordDescriptor(0, this.pipelineInputRecordDescriptor);
            }
            start = newRuntime;
        }
        return start;
    }
}

