/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;

public class PrefixMergePolicy
implements ILSMMergePolicy {
    private long maxMergableComponentSize;
    private int maxToleranceComponentCount;

    @Override
    public void diskComponentAdded(ILSMIndex index, boolean fullMergeIsRequested) throws HyracksDataException, IndexException {
        ArrayList<ILSMDiskComponent> immutableComponents = new ArrayList<ILSMDiskComponent>(index.getImmutableComponents());
        if (!this.areComponentsReadableWritableState(immutableComponents)) {
            return;
        }
        if (fullMergeIsRequested) {
            ILSMIndexAccessor accessor = index.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            accessor.scheduleFullMerge(index.getIOOperationCallback());
            return;
        }
        this.scheduleMerge(index);
    }

    @Override
    public void configure(Map<String, String> properties) {
        this.maxMergableComponentSize = Long.parseLong(properties.get("max-mergable-component-size"));
        this.maxToleranceComponentCount = Integer.parseInt(properties.get("max-tolerance-component-count"));
    }

    @Override
    public boolean isMergeLagging(ILSMIndex index) throws HyracksDataException, IndexException {
        List<ILSMDiskComponent> immutableComponents = index.getImmutableComponents();
        int mergableImmutableComponentCount = this.getMergableImmutableComponentCount(immutableComponents);
        if (mergableImmutableComponentCount < this.maxToleranceComponentCount) {
            return false;
        }
        boolean isMergeOngoing = this.isMergeOngoing(immutableComponents);
        if (isMergeOngoing) {
            return true;
        }
        if (!this.areComponentsReadableWritableState(immutableComponents)) {
            throw new IllegalStateException();
        }
        boolean isMergeTriggered = this.scheduleMerge(index);
        if (!isMergeTriggered) {
            throw new IllegalStateException();
        }
        return true;
    }

    private boolean isMergeOngoing(List<ILSMDiskComponent> immutableComponents) {
        int size = immutableComponents.size();
        for (int i = 0; i < size; ++i) {
            if (immutableComponents.get(i).getState() != ILSMComponent.ComponentState.READABLE_MERGING) continue;
            return true;
        }
        return false;
    }

    private int getMergableImmutableComponentCount(List<ILSMDiskComponent> immutableComponents) {
        int count = 0;
        for (ILSMComponent iLSMComponent : immutableComponents) {
            long componentSize = ((ILSMDiskComponent)iLSMComponent).getComponentSize();
            if (iLSMComponent.getState() != ILSMComponent.ComponentState.READABLE_UNWRITABLE || componentSize > this.maxMergableComponentSize) break;
            ++count;
        }
        return count;
    }

    private boolean areComponentsReadableWritableState(List<ILSMDiskComponent> immutableComponents) {
        for (ILSMComponent iLSMComponent : immutableComponents) {
            if (iLSMComponent.getState() == ILSMComponent.ComponentState.READABLE_UNWRITABLE) continue;
            return false;
        }
        return true;
    }

    private boolean scheduleMerge(ILSMIndex index) throws HyracksDataException, IndexException {
        ArrayList<ILSMDiskComponent> immutableComponents = new ArrayList<ILSMDiskComponent>(index.getImmutableComponents());
        Collections.reverse(immutableComponents);
        long totalSize = 0L;
        int startIndex = -1;
        for (int i = 0; i < immutableComponents.size(); ++i) {
            boolean isLastComponent;
            ILSMComponent c = (ILSMComponent)immutableComponents.get(i);
            long componentSize = ((ILSMDiskComponent)c).getComponentSize();
            if (componentSize > this.maxMergableComponentSize) {
                startIndex = i;
                totalSize = 0L;
                continue;
            }
            boolean bl = isLastComponent = i + 1 == immutableComponents.size();
            if ((totalSize += componentSize) <= this.maxMergableComponentSize && (!isLastComponent || i - startIndex < this.maxToleranceComponentCount)) continue;
            ArrayList<ILSMDiskComponent> mergableComponents = new ArrayList<ILSMDiskComponent>();
            for (int j = startIndex + 1; j <= i; ++j) {
                mergableComponents.add((ILSMDiskComponent)immutableComponents.get(j));
            }
            Collections.reverse(mergableComponents);
            ILSMIndexAccessor accessor = index.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            accessor.scheduleMerge(index.getIOOperationCallback(), mergableComponents);
            return true;
        }
        return false;
    }
}

