/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.replication.IIOReplicationManager;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.impls.ExternalIndexHarness;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IExtraPageBlockHelper;
import org.apache.hyracks.storage.common.buffercache.IFIFOPageQueue;
import org.apache.hyracks.storage.common.file.IFileMapManager;

public class MultitenantVirtualBufferCache
implements IVirtualBufferCache {
    private static final Logger LOGGER = Logger.getLogger(ExternalIndexHarness.class.getName());
    private final IVirtualBufferCache vbc;
    private int openCount;

    public MultitenantVirtualBufferCache(IVirtualBufferCache virtualBufferCache) {
        this.vbc = virtualBufferCache;
        this.openCount = 0;
    }

    public void createFile(FileReference fileRef) throws HyracksDataException {
        this.vbc.createFile(fileRef);
    }

    public void openFile(int fileId) throws HyracksDataException {
        this.vbc.openFile(fileId);
    }

    public void closeFile(int fileId) throws HyracksDataException {
        this.vbc.closeFile(fileId);
    }

    public void deleteFile(int fileId, boolean flushDirtyPages) throws HyracksDataException {
        this.vbc.deleteFile(fileId, flushDirtyPages);
    }

    public ICachedPage tryPin(long dpid) throws HyracksDataException {
        return this.vbc.tryPin(dpid);
    }

    public ICachedPage pin(long dpid, boolean newPage) throws HyracksDataException {
        return this.vbc.pin(dpid, newPage);
    }

    public void unpin(ICachedPage page) throws HyracksDataException {
        this.vbc.unpin(page);
    }

    public void flushDirtyPage(ICachedPage page) throws HyracksDataException {
        this.vbc.flushDirtyPage(page);
    }

    public void force(int fileId, boolean metadata) throws HyracksDataException {
        this.vbc.force(fileId, metadata);
    }

    public int getPageSize() {
        return this.vbc.getPageSize();
    }

    public int getPageSizeWithHeader() {
        return this.vbc.getPageSizeWithHeader();
    }

    public int getNumPages() {
        return this.vbc.getNumPages();
    }

    public synchronized void close() throws HyracksDataException {
        --this.openCount;
        if (this.openCount == 0) {
            this.vbc.close();
        }
    }

    @Override
    public synchronized void open() throws HyracksDataException {
        ++this.openCount;
        if (this.openCount == 1) {
            this.vbc.open();
        }
    }

    @Override
    public boolean isFull() {
        return this.vbc.isFull();
    }

    @Override
    public void reset() {
        this.vbc.reset();
    }

    @Override
    public IFileMapManager getFileMapProvider() {
        return this.vbc.getFileMapProvider();
    }

    public int getNumPagesOfFile(int fileId) throws HyracksDataException {
        throw new UnsupportedOperationException();
    }

    public void adviseWontNeed(ICachedPage page) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Calling adviseWontNeed on " + this.getClass().getName() + " makes no sense as this BufferCache cannot evict pages");
        }
    }

    public ICachedPage confiscatePage(long dpid) throws HyracksDataException {
        return this.vbc.confiscatePage(dpid);
    }

    public ICachedPage confiscateLargePage(long dpid, int multiplier, int extraBlockPageId) throws HyracksDataException {
        return this.vbc.confiscateLargePage(dpid, multiplier, extraBlockPageId);
    }

    public void returnPage(ICachedPage page) {
        this.vbc.returnPage(page);
    }

    public IFIFOPageQueue createFIFOQueue() {
        throw new UnsupportedOperationException("Virtual buffer caches don't have FIFO writers");
    }

    public void finishQueue() {
        throw new UnsupportedOperationException("Virtual buffer caches don't have FIFO writers");
    }

    public void setPageDiskId(ICachedPage page, long dpid) {
    }

    public void returnPage(ICachedPage page, boolean reinsert) {
    }

    public int getFileReferenceCount(int fileId) {
        return 0;
    }

    public boolean isReplicationEnabled() {
        return false;
    }

    public IIOReplicationManager getIOReplicationManager() {
        return null;
    }

    public void purgeHandle(int fileId) throws HyracksDataException {
    }

    public void resizePage(ICachedPage page, int multiplier, IExtraPageBlockHelper extraPageBlockHelper) throws HyracksDataException {
        this.vbc.resizePage(page, multiplier, extraPageBlockHelper);
    }
}

