/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.replication.IReplicationJob;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMMemoryComponent;

public class LSMHarness
implements ILSMHarness {
    private static final Logger LOGGER = Logger.getLogger(LSMHarness.class.getName());
    protected final ILSMIndex lsmIndex;
    protected final ILSMMergePolicy mergePolicy;
    protected final ILSMOperationTracker opTracker;
    protected final AtomicBoolean fullMergeIsRequested;
    protected final boolean replicationEnabled;
    protected List<ILSMDiskComponent> componentsToBeReplicated;

    public LSMHarness(ILSMIndex lsmIndex, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, boolean replicationEnabled) {
        this.lsmIndex = lsmIndex;
        this.opTracker = opTracker;
        this.mergePolicy = mergePolicy;
        this.fullMergeIsRequested = new AtomicBoolean();
        boolean bl = this.replicationEnabled = replicationEnabled && lsmIndex.isDurable();
        if (replicationEnabled) {
            this.componentsToBeReplicated = new ArrayList<ILSMDiskComponent>();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean getAndEnterComponents(ILSMIndexOperationContext ctx, LSMOperationType opType, boolean isTryOperation) throws HyracksDataException {
        this.validateOperationEnterComponentsState(ctx);
        ILSMOperationTracker iLSMOperationTracker = this.opTracker;
        synchronized (iLSMOperationTracker) {
            while (true) {
                this.lsmIndex.getOperationalComponents(ctx);
                switch (opType) {
                    case FLUSH: {
                        ILSMComponent flushingComponent = ctx.getComponentHolder().get(0);
                        if (!((AbstractLSMMemoryComponent)flushingComponent).isModified()) {
                            if (((AbstractLSMIndex)this.lsmIndex).getCurrentMutableComponentState() == ILSMComponent.ComponentState.READABLE_UNWRITABLE) {
                                ((AbstractLSMIndex)this.lsmIndex).setCurrentMutableComponentState(ILSMComponent.ComponentState.READABLE_WRITABLE);
                            }
                            return false;
                        }
                        if (((AbstractLSMMemoryComponent)flushingComponent).getWriterCount() <= 0) break;
                        return false;
                    }
                    case MERGE: {
                        if (ctx.getComponentHolder().size() >= 2) break;
                        return false;
                    }
                }
                if (this.enterComponents(ctx, opType)) {
                    return true;
                }
                if (isTryOperation) {
                    return false;
                }
                try {
                    this.opTracker.wait();
                }
                catch (InterruptedException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
        }
    }

    protected boolean enterComponents(ILSMIndexOperationContext ctx, LSMOperationType opType) throws HyracksDataException {
        block12: {
            int i;
            this.validateOperationEnterComponentsState(ctx);
            List<ILSMComponent> components = ctx.getComponentHolder();
            int numEntered = 0;
            boolean entranceSuccessful = false;
            try {
                for (ILSMComponent c : components) {
                    boolean isMutableComponent;
                    boolean bl = isMutableComponent = numEntered == 0 && c.getType() == ILSMComponent.LSMComponentType.MEMORY;
                    if (!c.threadEnter(opType, isMutableComponent)) break;
                    ++numEntered;
                }
                boolean bl = entranceSuccessful = numEntered == components.size();
                if (entranceSuccessful) break block12;
                i = 0;
            }
            catch (Throwable e) {
                try {
                    e.printStackTrace();
                    throw e;
                }
                catch (Throwable throwable) {
                    if (!entranceSuccessful) {
                        int i2 = 0;
                        for (ILSMComponent c : components) {
                            if (numEntered == 0) break;
                            boolean isMutableComponent = i2 == 0 && c.getType() == ILSMComponent.LSMComponentType.MEMORY;
                            c.threadExit(opType, true, isMutableComponent);
                            ++i2;
                            --numEntered;
                        }
                        return false;
                    }
                    ctx.setAccessingComponents(true);
                    throw throwable;
                }
            }
            for (ILSMComponent c : components) {
                if (numEntered == 0) break;
                boolean isMutableComponent = i == 0 && c.getType() == ILSMComponent.LSMComponentType.MEMORY;
                c.threadExit(opType, true, isMutableComponent);
                ++i;
                --numEntered;
            }
            return false;
        }
        ctx.setAccessingComponents(true);
        switch (opType) {
            case FLUSH: {
                this.lsmIndex.getIOOperationCallback().beforeOperation(LSMOperationType.FLUSH);
                this.lsmIndex.changeFlushStatusForCurrentMutableCompoent(false);
                this.lsmIndex.changeMutableComponent();
                this.opTracker.notifyAll();
                break;
            }
            case MERGE: {
                this.lsmIndex.getIOOperationCallback().beforeOperation(LSMOperationType.MERGE);
            }
        }
        this.opTracker.beforeOperation(this.lsmIndex, opType, ctx.getSearchOperationCallback(), ctx.getModificationCallback());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exitComponents(ILSMIndexOperationContext ctx, LSMOperationType opType, ILSMDiskComponent newComponent, boolean failedOperation) throws HyracksDataException, IndexException {
        void var6_7;
        if (!ctx.isAccessingComponents() && opType != LSMOperationType.FLUSH && opType != LSMOperationType.MERGE) {
            return;
        }
        List<ILSMDiskComponent> inactiveDiskComponents = null;
        List list = null;
        try {
            ILSMOperationTracker iLSMOperationTracker = this.opTracker;
            synchronized (iLSMOperationTracker) {
                block51: {
                    block50: {
                        try {
                            if (opType == LSMOperationType.FLUSH) {
                                while (this.mergePolicy.isMergeLagging(this.lsmIndex)) {
                                    try {
                                        this.opTracker.wait();
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                            } else if (opType == LSMOperationType.MERGE) {
                                this.opTracker.notifyAll();
                            }
                            boolean bl = false;
                            for (ILSMComponent c : ctx.getComponentHolder()) {
                                void var8_15;
                                boolean isMutableComponent = var8_15 == false && c.getType() == ILSMComponent.LSMComponentType.MEMORY;
                                c.threadExit(opType, failedOperation, isMutableComponent);
                                if (c.getType() == ILSMComponent.LSMComponentType.MEMORY) {
                                    switch (c.getState()) {
                                        case READABLE_UNWRITABLE: {
                                            if (!isMutableComponent || opType != LSMOperationType.MODIFICATION && opType != LSMOperationType.FORCE_MODIFICATION) break;
                                            this.lsmIndex.changeFlushStatusForCurrentMutableCompoent(true);
                                            break;
                                        }
                                        case INACTIVE: {
                                            ((AbstractLSMMemoryComponent)c).reset();
                                            this.opTracker.notifyAll();
                                            break;
                                        }
                                    }
                                } else {
                                    switch (c.getState()) {
                                        case INACTIVE: {
                                            this.lsmIndex.addInactiveDiskComponent((AbstractLSMDiskComponent)c);
                                            break;
                                        }
                                    }
                                }
                                ++var8_15;
                            }
                            ctx.setAccessingComponents(false);
                            switch (opType) {
                                case FLUSH: {
                                    if (newComponent == null) break;
                                    this.lsmIndex.addDiskComponent(newComponent);
                                    if (this.replicationEnabled) {
                                        this.componentsToBeReplicated.clear();
                                        this.componentsToBeReplicated.add(newComponent);
                                        this.triggerReplication(this.componentsToBeReplicated, false, opType);
                                    }
                                    this.mergePolicy.diskComponentAdded(this.lsmIndex, false);
                                    break;
                                }
                                case MERGE: {
                                    if (newComponent == null) break;
                                    this.lsmIndex.subsumeMergedComponents(newComponent, ctx.getComponentHolder());
                                    if (this.replicationEnabled) {
                                        this.componentsToBeReplicated.clear();
                                        this.componentsToBeReplicated.add(newComponent);
                                        this.triggerReplication(this.componentsToBeReplicated, false, opType);
                                    }
                                    this.mergePolicy.diskComponentAdded(this.lsmIndex, this.fullMergeIsRequested.get());
                                    break;
                                }
                            }
                            if (!failedOperation || opType != LSMOperationType.MODIFICATION && opType != LSMOperationType.FORCE_MODIFICATION) break block50;
                        }
                        catch (Throwable throwable) {
                            try {
                                throwable.printStackTrace();
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                void var6_9;
                                if (failedOperation && (opType == LSMOperationType.MODIFICATION || opType == LSMOperationType.FORCE_MODIFICATION)) {
                                    this.opTracker.completeOperation(this.lsmIndex, opType, ctx.getSearchOperationCallback(), ctx.getModificationCallback());
                                } else {
                                    this.opTracker.afterOperation(this.lsmIndex, opType, ctx.getSearchOperationCallback(), ctx.getModificationCallback());
                                }
                                inactiveDiskComponents = this.lsmIndex.getInactiveDiskComponents();
                                if (inactiveDiskComponents.isEmpty()) throw throwable2;
                                for (ILSMDiskComponent inactiveComp : inactiveDiskComponents) {
                                    if (inactiveComp.getFileReferenceCount() != 1) continue;
                                    if (var6_9 == null) {
                                        LinkedList linkedList = new LinkedList();
                                    }
                                    var6_9.add(inactiveComp);
                                }
                                if (var6_9 == null) throw throwable2;
                                inactiveDiskComponents.removeAll((Collection<?>)var6_9);
                                throw throwable2;
                            }
                        }
                        this.opTracker.completeOperation(this.lsmIndex, opType, ctx.getSearchOperationCallback(), ctx.getModificationCallback());
                        break block51;
                    }
                    this.opTracker.afterOperation(this.lsmIndex, opType, ctx.getSearchOperationCallback(), ctx.getModificationCallback());
                }
                inactiveDiskComponents = this.lsmIndex.getInactiveDiskComponents();
                if (!inactiveDiskComponents.isEmpty()) {
                    for (ILSMDiskComponent inactiveComp : inactiveDiskComponents) {
                        if (inactiveComp.getFileReferenceCount() != 1) continue;
                        if (var6_7 == null) {
                            LinkedList linkedList = new LinkedList();
                        }
                        var6_7.add(inactiveComp);
                    }
                    if (var6_7 != null) {
                        inactiveDiskComponents.removeAll((Collection<?>)var6_7);
                    }
                }
            }
            if (var6_7 == null) return;
        }
        catch (Throwable throwable) {
            if (list == null) throw throwable;
            try {
                if (this.replicationEnabled) {
                    this.lsmIndex.scheduleReplication(null, list, false, IReplicationJob.ReplicationOperation.DELETE, opType);
                }
                for (ILSMComponent iLSMComponent : list) {
                    ((AbstractLSMDiskComponent)iLSMComponent).destroy();
                }
                throw throwable;
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw e;
            }
        }
        try {
            if (this.replicationEnabled) {
                this.lsmIndex.scheduleReplication(null, (List<ILSMDiskComponent>)var6_7, false, IReplicationJob.ReplicationOperation.DELETE, opType);
            }
            for (ILSMComponent iLSMComponent : var6_7) {
                ((AbstractLSMDiskComponent)iLSMComponent).destroy();
            }
            return;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void forceModify(ILSMIndexOperationContext ctx, ITupleReference tuple) throws HyracksDataException, IndexException {
        LSMOperationType opType = LSMOperationType.FORCE_MODIFICATION;
        this.modify(ctx, false, tuple, opType);
    }

    @Override
    public boolean modify(ILSMIndexOperationContext ctx, boolean tryOperation, ITupleReference tuple) throws HyracksDataException, IndexException {
        LSMOperationType opType = LSMOperationType.MODIFICATION;
        return this.modify(ctx, tryOperation, tuple, opType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMeta(ILSMIndexOperationContext ctx, IValueReference key, IValueReference value) throws HyracksDataException {
        if (!this.lsmIndex.isMemoryComponentsAllocated()) {
            this.lsmIndex.allocateMemoryComponents();
        }
        this.getAndEnterComponents(ctx, LSMOperationType.MODIFICATION, false);
        try {
            this.lsmIndex.getCurrentMemoryComponent().getMetadata().put(key, value);
        }
        finally {
            this.exitAndComplete(ctx, LSMOperationType.MODIFICATION);
        }
    }

    private void exitAndComplete(ILSMIndexOperationContext ctx, LSMOperationType op) throws HyracksDataException {
        try {
            this.exitComponents(ctx, op, null, false);
        }
        catch (IndexException e) {
            throw new HyracksDataException((Throwable)e);
        }
        finally {
            this.opTracker.completeOperation(null, op, null, ctx.getModificationCallback());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceUpdateMeta(ILSMIndexOperationContext ctx, IValueReference key, IValueReference value) throws HyracksDataException {
        if (!this.lsmIndex.isMemoryComponentsAllocated()) {
            this.lsmIndex.allocateMemoryComponents();
        }
        this.getAndEnterComponents(ctx, LSMOperationType.FORCE_MODIFICATION, false);
        try {
            this.lsmIndex.getCurrentMemoryComponent().getMetadata().put(key, value);
        }
        finally {
            this.exitAndComplete(ctx, LSMOperationType.FORCE_MODIFICATION);
        }
    }

    private boolean modify(ILSMIndexOperationContext ctx, boolean tryOperation, ITupleReference tuple, LSMOperationType opType) throws HyracksDataException, IndexException {
        if (!this.lsmIndex.isMemoryComponentsAllocated()) {
            this.lsmIndex.allocateMemoryComponents();
        }
        boolean failedOperation = false;
        if (!this.getAndEnterComponents(ctx, opType, tryOperation)) {
            return false;
        }
        try {
            this.lsmIndex.modify(ctx, tuple);
            AbstractLSMMemoryComponent mutableComponent = (AbstractLSMMemoryComponent)ctx.getComponentHolder().get(0);
            mutableComponent.setModified();
        }
        catch (Exception e) {
            failedOperation = true;
            throw e;
        }
        finally {
            this.exitComponents(ctx, opType, null, failedOperation);
        }
        return true;
    }

    @Override
    public void search(ILSMIndexOperationContext ctx, IIndexCursor cursor, ISearchPredicate pred) throws HyracksDataException, IndexException {
        LSMOperationType opType = LSMOperationType.SEARCH;
        ctx.setSearchPredicate(pred);
        this.getAndEnterComponents(ctx, opType, false);
        try {
            ctx.getSearchOperationCallback().before(pred.getLowKey());
            this.lsmIndex.search(ctx, cursor, pred);
        }
        catch (HyracksDataException | IndexException e) {
            this.exitComponents(ctx, opType, null, true);
            throw e;
        }
    }

    @Override
    public void endSearch(ILSMIndexOperationContext ctx) throws HyracksDataException {
        if (ctx.getOperation() == IndexOperation.SEARCH) {
            try {
                this.exitComponents(ctx, LSMOperationType.SEARCH, null, false);
            }
            catch (IndexException e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
    }

    @Override
    public void scheduleFlush(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException {
        if (!this.getAndEnterComponents(ctx, LSMOperationType.FLUSH, true)) {
            callback.afterFinalize(LSMOperationType.FLUSH, null);
            return;
        }
        this.lsmIndex.scheduleFlush(ctx, callback);
    }

    @Override
    public void flush(ILSMIndexOperationContext ctx, ILSMIOOperation operation) throws HyracksDataException, IndexException {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Started a flush operation for index: " + this.lsmIndex + " ...");
        }
        ILSMDiskComponent newComponent = null;
        try {
            newComponent = this.lsmIndex.flush(operation);
            operation.getCallback().afterOperation(LSMOperationType.FLUSH, null, newComponent);
            this.lsmIndex.markAsValid(newComponent);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.exitComponents(ctx, LSMOperationType.FLUSH, newComponent, false);
            operation.getCallback().afterFinalize(LSMOperationType.FLUSH, newComponent);
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Finished the flush operation for index: " + this.lsmIndex);
        }
    }

    @Override
    public void scheduleMerge(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException, IndexException {
        if (!this.getAndEnterComponents(ctx, LSMOperationType.MERGE, true)) {
            callback.afterFinalize(LSMOperationType.MERGE, null);
            return;
        }
        this.lsmIndex.scheduleMerge(ctx, callback);
    }

    @Override
    public void scheduleFullMerge(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException, IndexException {
        this.fullMergeIsRequested.set(true);
        if (!this.getAndEnterComponents(ctx, LSMOperationType.MERGE, true)) {
            callback.afterFinalize(LSMOperationType.MERGE, null);
            return;
        }
        this.fullMergeIsRequested.set(false);
        this.lsmIndex.scheduleMerge(ctx, callback);
    }

    @Override
    public void merge(ILSMIndexOperationContext ctx, ILSMIOOperation operation) throws HyracksDataException, IndexException {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Started a merge operation for index: " + this.lsmIndex + " ...");
        }
        ILSMDiskComponent newComponent = null;
        try {
            newComponent = this.lsmIndex.merge(operation);
            operation.getCallback().afterOperation(LSMOperationType.MERGE, ctx.getComponentHolder(), newComponent);
            this.lsmIndex.markAsValid(newComponent);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.exitComponents(ctx, LSMOperationType.MERGE, newComponent, false);
            operation.getCallback().afterFinalize(LSMOperationType.MERGE, newComponent);
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Finished the merge operation for index: " + this.lsmIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBulkLoadedComponent(ILSMDiskComponent c) throws HyracksDataException, IndexException {
        this.lsmIndex.markAsValid(c);
        ILSMOperationTracker iLSMOperationTracker = this.opTracker;
        synchronized (iLSMOperationTracker) {
            this.lsmIndex.addDiskComponent(c);
            if (this.replicationEnabled) {
                this.componentsToBeReplicated.clear();
                this.componentsToBeReplicated.add(c);
                this.triggerReplication(this.componentsToBeReplicated, true, LSMOperationType.MERGE);
            }
            this.mergePolicy.diskComponentAdded(this.lsmIndex, false);
        }
    }

    @Override
    public ILSMOperationTracker getOperationTracker() {
        return this.opTracker;
    }

    protected void triggerReplication(List<ILSMDiskComponent> lsmComponents, boolean bulkload, LSMOperationType opType) throws HyracksDataException {
        ILSMIndexAccessor accessor = this.lsmIndex.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        accessor.scheduleReplication(lsmComponents, bulkload, opType);
    }

    @Override
    public void scheduleReplication(ILSMIndexOperationContext ctx, List<ILSMDiskComponent> lsmComponents, boolean bulkload, LSMOperationType opType) throws HyracksDataException {
        if (!this.getAndEnterComponents(ctx, LSMOperationType.REPLICATE, false)) {
            return;
        }
        this.lsmIndex.scheduleReplication(ctx, lsmComponents, bulkload, IReplicationJob.ReplicationOperation.REPLICATE, opType);
    }

    @Override
    public void endReplication(ILSMIndexOperationContext ctx) throws HyracksDataException {
        try {
            this.exitComponents(ctx, LSMOperationType.REPLICATE, null, false);
        }
        catch (IndexException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    protected void validateOperationEnterComponentsState(ILSMIndexOperationContext ctx) throws HyracksDataException {
        if (ctx.isAccessingComponents()) {
            throw new HyracksDataException("Opeartion already has access to components of index " + this.lsmIndex);
        }
    }
}

