/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexMetadataFrame;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;
import org.apache.hyracks.storage.common.file.IFileMapProvider;

public abstract class AbstractLSMIndexFileManager
implements ILSMIndexFileManager {
    public static final String SPLIT_STRING = "_";
    protected static final String BLOOM_FILTER_STRING = "f";
    protected static final String TRANSACTION_PREFIX = ".T";
    protected final IIOManager ioManager;
    protected final IFileMapProvider fileMapProvider;
    protected String baseDir;
    protected final Format formatter = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
    protected final Comparator<String> cmp = new FileNameComparator();
    protected final Comparator<ComparableFileName> recencyCmp = new RecencyComparator();
    protected final TreeIndexFactory<? extends ITreeIndex> treeFactory;
    private String prevTimestamp = null;
    private static FilenameFilter fileNameFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return !name.startsWith(".");
        }
    };
    protected static FilenameFilter bloomFilterFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return !name.startsWith(".") && name.endsWith(AbstractLSMIndexFileManager.BLOOM_FILTER_STRING);
        }
    };
    protected static FilenameFilter transactionFileNameFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith(AbstractLSMIndexFileManager.TRANSACTION_PREFIX);
        }
    };
    protected static FilenameFilter dummyFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return true;
        }
    };

    public AbstractLSMIndexFileManager(IIOManager ioManager, IFileMapProvider fileMapProvider, FileReference file, TreeIndexFactory<? extends ITreeIndex> treeFactory) {
        this.ioManager = ioManager;
        this.baseDir = file.getFile().getAbsolutePath();
        if (!this.baseDir.endsWith(System.getProperty("file.separator"))) {
            this.baseDir = this.baseDir + System.getProperty("file.separator");
        }
        this.fileMapProvider = fileMapProvider;
        this.treeFactory = treeFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TreeIndexState isValidTreeIndex(ITreeIndex treeIndex) throws HyracksDataException {
        IBufferCache bufferCache = treeIndex.getBufferCache();
        treeIndex.activate();
        try {
            ICachedPage page;
            block13: {
                ITreeIndexMetadataFrame metadataFrame;
                block12: {
                    TreeIndexState treeIndexState;
                    int metadataPage = treeIndex.getPageManager().getMetadataPageId();
                    if (metadataPage < 0) {
                        TreeIndexState treeIndexState2 = TreeIndexState.INVALID;
                        return treeIndexState2;
                    }
                    metadataFrame = treeIndex.getPageManager().createMetadataFrame();
                    page = bufferCache.pin(BufferedFileHandle.getDiskPageId((int)treeIndex.getFileId(), (int)metadataPage), false);
                    page.acquireReadLatch();
                    try {
                        metadataFrame.setPage(page);
                        if (metadataFrame.isValid()) break block12;
                        treeIndexState = TreeIndexState.INVALID;
                    }
                    catch (Throwable throwable) {
                        page.releaseReadLatch();
                        bufferCache.unpin(page);
                        throw throwable;
                    }
                    page.releaseReadLatch();
                    bufferCache.unpin(page);
                    return treeIndexState;
                }
                if (metadataFrame.getVersion() == 5) break block13;
                TreeIndexState treeIndexState = TreeIndexState.VERSION_MISMATCH;
                page.releaseReadLatch();
                bufferCache.unpin(page);
                return treeIndexState;
            }
            TreeIndexState treeIndexState = TreeIndexState.VALID;
            page.releaseReadLatch();
            bufferCache.unpin(page);
            return treeIndexState;
        }
        finally {
            treeIndex.deactivate();
        }
    }

    protected void cleanupAndGetValidFilesInternal(FilenameFilter filter, TreeIndexFactory<? extends ITreeIndex> treeFactory, ArrayList<ComparableFileName> allFiles) throws HyracksDataException, IndexException {
        String[] files = AbstractLSMIndexFileManager.listDirFiles(this.baseDir, filter);
        File dir = new File(this.baseDir);
        for (String fileName : files) {
            FileReference fileRef = this.ioManager.resolveAbsolutePath(dir.getPath() + File.separator + fileName);
            if (treeFactory == null) {
                allFiles.add(new ComparableFileName(fileRef));
                continue;
            }
            TreeIndexState idxState = this.isValidTreeIndex((ITreeIndex)treeFactory.createIndexInstance(fileRef));
            if (idxState == TreeIndexState.VALID) {
                allFiles.add(new ComparableFileName(fileRef));
                continue;
            }
            if (idxState != TreeIndexState.INVALID) continue;
            fileRef.delete();
        }
    }

    static String[] listDirFiles(String path, FilenameFilter filter) throws HyracksDataException {
        File dir = new File(path);
        String[] files = dir.list(filter);
        if (files == null) {
            if (!dir.canRead()) {
                throw HyracksDataException.create((int)28, (Serializable[])new Serializable[]{path});
            }
            if (!dir.exists()) {
                throw HyracksDataException.create((int)30, (Serializable[])new Serializable[]{path});
            }
            if (!dir.isDirectory()) {
                throw HyracksDataException.create((int)27, (Serializable[])new Serializable[]{path});
            }
            throw HyracksDataException.create((int)29, (Serializable[])new Serializable[]{path});
        }
        return files;
    }

    protected void validateFiles(HashSet<String> groundTruth, ArrayList<ComparableFileName> validFiles, FilenameFilter filter, TreeIndexFactory<? extends ITreeIndex> treeFactory) throws HyracksDataException, IndexException {
        ArrayList<ComparableFileName> tmpAllInvListsFiles = new ArrayList<ComparableFileName>();
        this.cleanupAndGetValidFilesInternal(filter, treeFactory, tmpAllInvListsFiles);
        for (ComparableFileName cmpFileName : tmpAllInvListsFiles) {
            int index = cmpFileName.fileName.lastIndexOf(SPLIT_STRING);
            String file = cmpFileName.fileName.substring(0, index);
            if (groundTruth.contains(file)) {
                validFiles.add(cmpFileName);
                continue;
            }
            File invalidFile = new File(cmpFileName.fullPath);
            invalidFile.delete();
        }
    }

    @Override
    public void createDirs() {
        File f = new File(this.baseDir);
        f.mkdirs();
    }

    @Override
    public void deleteDirs() throws HyracksDataException {
        File f = new File(this.baseDir);
        if (f.exists()) {
            this.delete(f);
        }
    }

    private void delete(File f) throws HyracksDataException {
        if (!FileUtils.deleteQuietly((File)f)) {
            throw HyracksDataException.create((int)31, (Serializable[])new Serializable[]{f.getPath()});
        }
    }

    protected FileReference createFlushFile(String flushFileName) throws HyracksDataException {
        return this.ioManager.resolveAbsolutePath(flushFileName);
    }

    protected FileReference createMergeFile(String mergeFileName) throws HyracksDataException {
        return this.createFlushFile(mergeFileName);
    }

    @Override
    public LSMComponentFileReferences getRelFlushFileReference() throws HyracksDataException {
        String ts = this.getCurrentTimestamp();
        return new LSMComponentFileReferences(this.createFlushFile(this.baseDir + ts + SPLIT_STRING + ts), null, null);
    }

    @Override
    public LSMComponentFileReferences getRelMergeFileReference(String firstFileName, String lastFileName) throws HyracksDataException {
        String[] firstTimestampRange = firstFileName.split(SPLIT_STRING);
        String[] lastTimestampRange = lastFileName.split(SPLIT_STRING);
        return new LSMComponentFileReferences(this.createMergeFile(this.baseDir + firstTimestampRange[0] + SPLIT_STRING + lastTimestampRange[1]), null, null);
    }

    @Override
    public List<LSMComponentFileReferences> cleanupAndGetValidFiles() throws HyracksDataException, IndexException {
        ArrayList<LSMComponentFileReferences> validFiles = new ArrayList<LSMComponentFileReferences>();
        ArrayList<ComparableFileName> allFiles = new ArrayList<ComparableFileName>();
        this.cleanupAndGetValidFilesInternal(fileNameFilter, this.treeFactory, allFiles);
        if (allFiles.isEmpty()) {
            return validFiles;
        }
        if (allFiles.size() == 1) {
            validFiles.add(new LSMComponentFileReferences(allFiles.get((int)0).fileRef, null, null));
            return validFiles;
        }
        Collections.sort(allFiles);
        ArrayList<ComparableFileName> validComparableFiles = new ArrayList<ComparableFileName>();
        ComparableFileName last = allFiles.get(0);
        validComparableFiles.add(last);
        for (int i = 1; i < allFiles.size(); ++i) {
            ComparableFileName current = allFiles.get(i);
            if (current.interval[0].compareTo(last.interval[1]) > 0) {
                validComparableFiles.add(current);
                last = current;
                continue;
            }
            if (current.interval[0].compareTo(last.interval[0]) >= 0 && current.interval[1].compareTo(last.interval[1]) <= 0) {
                current.fileRef.delete();
                continue;
            }
            throw new HyracksDataException("Found LSM files with overlapping timestamp intervals, but the intervals were not contained by another file.");
        }
        Collections.sort(validComparableFiles, this.recencyCmp);
        for (ComparableFileName cmpFileName : validComparableFiles) {
            validFiles.add(new LSMComponentFileReferences(cmpFileName.fileRef, null, null));
        }
        return validFiles;
    }

    @Override
    public Comparator<String> getFileNameComparator() {
        return this.cmp;
    }

    @Override
    public String getBaseDir() {
        return this.baseDir;
    }

    @Override
    public void recoverTransaction() throws HyracksDataException {
        String[] files = AbstractLSMIndexFileManager.listDirFiles(this.baseDir, transactionFileNameFilter);
        File dir = new File(this.baseDir);
        try {
            if (files.length != 0) {
                if (files.length > 1) {
                    throw new HyracksDataException("Found more than one transaction");
                }
                Files.delete(Paths.get(dir.getPath() + File.separator + files[0], new String[0]));
            }
        }
        catch (IOException e) {
            throw new HyracksDataException("Failed to recover transaction", (Throwable)e);
        }
    }

    @Override
    public void deleteTransactionFiles() throws HyracksDataException {
        String[] files = AbstractLSMIndexFileManager.listDirFiles(this.baseDir, transactionFileNameFilter);
        if (files.length != 0) {
            String[] componentsFiles;
            if (files.length > 1) {
                throw new HyracksDataException("Found more than one transaction");
            }
            File dir = new File(this.baseDir);
            FilenameFilter transactionFilter = AbstractLSMIndexFileManager.createTransactionFilter(files[0], true);
            for (String fileName : componentsFiles = AbstractLSMIndexFileManager.listDirFiles(this.baseDir, transactionFilter)) {
                try {
                    String absFileName = dir.getPath() + File.separator + fileName;
                    Files.delete(Paths.get(absFileName, new String[0]));
                }
                catch (IOException e) {
                    throw new HyracksDataException("Failed to delete transaction files", (Throwable)e);
                }
            }
            String absFileName = dir.getPath() + File.separator + files[0];
            try {
                Files.delete(Paths.get(absFileName, new String[0]));
            }
            catch (IOException e) {
                throw new HyracksDataException("Failed to delete transaction files", (Throwable)e);
            }
        }
    }

    @Override
    public LSMComponentFileReferences getNewTransactionFileReference() throws IOException {
        return null;
    }

    @Override
    public LSMComponentFileReferences getTransactionFileReferenceForCommit() throws HyracksDataException {
        return null;
    }

    protected static FilenameFilter createTransactionFilter(String transactionFileName, final boolean inclusive) {
        final String timeStamp = transactionFileName.substring(transactionFileName.indexOf(TRANSACTION_PREFIX) + TRANSACTION_PREFIX.length());
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (inclusive) {
                    return name.startsWith(timeStamp);
                }
                return !name.startsWith(timeStamp);
            }
        };
    }

    protected FilenameFilter getTransactionFileFilter(boolean inclusive) throws HyracksDataException {
        String[] files = AbstractLSMIndexFileManager.listDirFiles(this.baseDir, transactionFileNameFilter);
        if (files.length == 0) {
            return dummyFilter;
        }
        return AbstractLSMIndexFileManager.createTransactionFilter(files[0], inclusive);
    }

    protected FilenameFilter getCompoundFilter(final FilenameFilter filter1, final FilenameFilter filter2) {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return filter1.accept(dir, name) && filter2.accept(dir, name);
            }
        };
    }

    protected String getCurrentTimestamp() {
        Date date = new Date();
        String ts = this.formatter.format(date);
        while (this.prevTimestamp != null && ts.compareTo(this.prevTimestamp) == 0) {
            try {
                Thread.sleep(1L);
                date = new Date();
                ts = this.formatter.format(date);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.prevTimestamp = ts;
        return ts;
    }

    private class RecencyComparator
    implements Comparator<ComparableFileName> {
        private RecencyComparator() {
        }

        @Override
        public int compare(ComparableFileName a, ComparableFileName b) {
            int cmp = -a.interval[0].compareTo(b.interval[0]);
            if (cmp != 0) {
                return cmp;
            }
            return -a.interval[1].compareTo(b.interval[1]);
        }
    }

    protected class ComparableFileName
    implements Comparable<ComparableFileName> {
        public final FileReference fileRef;
        public final String fullPath;
        public final String fileName;
        public final String[] interval;

        public ComparableFileName(FileReference fileRef) {
            this.fileRef = fileRef;
            this.fullPath = fileRef.getFile().getAbsolutePath();
            this.fileName = fileRef.getFile().getName();
            this.interval = this.fileName.split(AbstractLSMIndexFileManager.SPLIT_STRING);
        }

        @Override
        public int compareTo(ComparableFileName b) {
            int startCmp = this.interval[0].compareTo(b.interval[0]);
            if (startCmp != 0) {
                return startCmp;
            }
            return b.interval[1].compareTo(this.interval[1]);
        }
    }

    private class FileNameComparator
    implements Comparator<String> {
        private FileNameComparator() {
        }

        @Override
        public int compare(String a, String b) {
            return -a.compareTo(b);
        }
    }

    public static enum TreeIndexState {
        INVALID,
        VERSION_MISMATCH,
        VALID;

    }
}

