/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.replication.IReplicationJob;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterFrameFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.ExternalIndexHarness;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMHarness;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexReplicationJob;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.file.IFileMapProvider;

public abstract class AbstractLSMIndex
implements ILSMIndex {
    protected final ILSMHarness lsmHarness;
    protected final IIOManager ioManager;
    protected final ILSMIOOperationScheduler ioScheduler;
    protected final ILSMIOOperationCallback ioOpCallback;
    protected final List<ILSMMemoryComponent> memoryComponents;
    protected final List<IVirtualBufferCache> virtualBufferCaches;
    protected AtomicInteger currentMutableComponentId;
    protected final IBufferCache diskBufferCache;
    protected final ILSMIndexFileManager fileManager;
    protected final IFileMapProvider diskFileMapProvider;
    protected final List<ILSMDiskComponent> diskComponents;
    protected final List<ILSMDiskComponent> inactiveDiskComponents;
    protected final double bloomFilterFalsePositiveRate;
    protected final ILSMComponentFilterFrameFactory filterFrameFactory;
    protected final LSMComponentFilterManager filterManager;
    protected final int[] filterFields;
    protected final boolean durable;
    protected boolean isActivated;
    protected final AtomicBoolean[] flushRequests;
    protected boolean memoryComponentsAllocated = false;

    public AbstractLSMIndex(IIOManager ioManager, List<IVirtualBufferCache> virtualBufferCaches, IBufferCache diskBufferCache, ILSMIndexFileManager fileManager, IFileMapProvider diskFileMapProvider, double bloomFilterFalsePositiveRate, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, ILSMComponentFilterFrameFactory filterFrameFactory, LSMComponentFilterManager filterManager, int[] filterFields, boolean durable) {
        this.ioManager = ioManager;
        this.virtualBufferCaches = virtualBufferCaches;
        this.diskBufferCache = diskBufferCache;
        this.diskFileMapProvider = diskFileMapProvider;
        this.fileManager = fileManager;
        this.bloomFilterFalsePositiveRate = bloomFilterFalsePositiveRate;
        this.ioScheduler = ioScheduler;
        this.ioOpCallback = ioOpCallback;
        this.ioOpCallback.setNumOfMutableComponents(virtualBufferCaches.size());
        this.filterFrameFactory = filterFrameFactory;
        this.filterManager = filterManager;
        this.filterFields = filterFields;
        this.inactiveDiskComponents = new LinkedList<ILSMDiskComponent>();
        this.durable = durable;
        this.lsmHarness = new LSMHarness(this, mergePolicy, opTracker, diskBufferCache.isReplicationEnabled());
        this.isActivated = false;
        this.diskComponents = new ArrayList<ILSMDiskComponent>();
        this.memoryComponents = new ArrayList<ILSMMemoryComponent>();
        this.currentMutableComponentId = new AtomicInteger();
        this.flushRequests = new AtomicBoolean[virtualBufferCaches.size()];
        for (int i = 0; i < virtualBufferCaches.size(); ++i) {
            this.flushRequests[i] = new AtomicBoolean();
        }
    }

    public AbstractLSMIndex(IIOManager ioManager, IBufferCache diskBufferCache, ILSMIndexFileManager fileManager, IFileMapProvider diskFileMapProvider, double bloomFilterFalsePositiveRate, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, boolean durable) {
        this.ioManager = ioManager;
        this.diskBufferCache = diskBufferCache;
        this.diskFileMapProvider = diskFileMapProvider;
        this.fileManager = fileManager;
        this.bloomFilterFalsePositiveRate = bloomFilterFalsePositiveRate;
        this.ioScheduler = ioScheduler;
        this.ioOpCallback = ioOpCallback;
        this.durable = durable;
        this.lsmHarness = new ExternalIndexHarness(this, mergePolicy, opTracker, diskBufferCache.isReplicationEnabled());
        this.isActivated = false;
        this.diskComponents = new LinkedList<ILSMDiskComponent>();
        this.inactiveDiskComponents = new LinkedList<ILSMDiskComponent>();
        this.virtualBufferCaches = null;
        this.memoryComponents = null;
        this.currentMutableComponentId = null;
        this.flushRequests = null;
        this.filterFrameFactory = null;
        this.filterManager = null;
        this.filterFields = null;
    }

    protected void markAsValidInternal(ITreeIndex treeIndex) throws HyracksDataException {
        int fileId = treeIndex.getFileId();
        IBufferCache bufferCache = treeIndex.getBufferCache();
        treeIndex.getPageManager().close();
        if (this.durable) {
            bufferCache.force(fileId, true);
        }
    }

    protected void markAsValidInternal(IBufferCache bufferCache, BloomFilter filter) throws HyracksDataException {
        if (this.durable) {
            bufferCache.force(filter.getFileId(), true);
        }
    }

    @Override
    public void addDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        this.diskComponents.add(0, c);
    }

    @Override
    public void subsumeMergedComponents(ILSMDiskComponent newComponent, List<ILSMComponent> mergedComponents) throws HyracksDataException {
        int swapIndex = this.diskComponents.indexOf(mergedComponents.get(0));
        this.diskComponents.removeAll(mergedComponents);
        this.diskComponents.add(swapIndex, newComponent);
    }

    @Override
    public void changeMutableComponent() {
        this.currentMutableComponentId.set((this.currentMutableComponentId.get() + 1) % this.memoryComponents.size());
        this.memoryComponents.get(this.currentMutableComponentId.get()).activate();
    }

    @Override
    public List<ILSMDiskComponent> getImmutableComponents() {
        return this.diskComponents;
    }

    @Override
    public void changeFlushStatusForCurrentMutableCompoent(boolean needsFlush) {
        this.flushRequests[this.currentMutableComponentId.get()].set(needsFlush);
    }

    @Override
    public boolean hasFlushRequestForCurrentMutableComponent() {
        return this.flushRequests[this.currentMutableComponentId.get()].get();
    }

    @Override
    public ILSMOperationTracker getOperationTracker() {
        return this.lsmHarness.getOperationTracker();
    }

    @Override
    public ILSMIOOperationScheduler getIOScheduler() {
        return this.ioScheduler;
    }

    @Override
    public ILSMIOOperationCallback getIOOperationCallback() {
        return this.ioOpCallback;
    }

    public IBufferCache getBufferCache() {
        return this.diskBufferCache;
    }

    public boolean isEmptyIndex() {
        boolean isModified = false;
        for (ILSMComponent iLSMComponent : this.memoryComponents) {
            AbstractLSMMemoryComponent mutableComponent = (AbstractLSMMemoryComponent)iLSMComponent;
            if (!mutableComponent.isModified()) continue;
            isModified = true;
            break;
        }
        return this.diskComponents.isEmpty() && !isModified;
    }

    public String toString() {
        return "LSMIndex [" + this.fileManager.getBaseDir() + "]";
    }

    public boolean hasMemoryComponents() {
        return true;
    }

    @Override
    public boolean isCurrentMutableComponentEmpty() throws HyracksDataException {
        return !this.memoryComponents.get(this.currentMutableComponentId.get()).isModified();
    }

    public void setCurrentMutableComponentState(ILSMComponent.ComponentState componentState) {
        this.memoryComponents.get(this.currentMutableComponentId.get()).setState(componentState);
    }

    public ILSMComponent.ComponentState getCurrentMutableComponentState() {
        return this.memoryComponents.get(this.currentMutableComponentId.get()).getState();
    }

    public int getCurrentMutableComponentWriterCount() {
        return this.memoryComponents.get(this.currentMutableComponentId.get()).getWriterCount();
    }

    @Override
    public List<ILSMDiskComponent> getInactiveDiskComponents() {
        return this.inactiveDiskComponents;
    }

    @Override
    public void addInactiveDiskComponent(ILSMDiskComponent diskComponent) {
        this.inactiveDiskComponents.add(diskComponent);
    }

    public abstract Set<String> getLSMComponentPhysicalFiles(ILSMComponent var1);

    @Override
    public void scheduleReplication(ILSMIndexOperationContext ctx, List<ILSMDiskComponent> lsmComponents, boolean bulkload, IReplicationJob.ReplicationOperation operation, LSMOperationType opType) throws HyracksDataException {
        HashSet<String> componentFiles = new HashSet<String>();
        for (ILSMComponent iLSMComponent : lsmComponents) {
            componentFiles.addAll(this.getLSMComponentPhysicalFiles(iLSMComponent));
        }
        IReplicationJob.ReplicationExecutionType executionType = bulkload ? IReplicationJob.ReplicationExecutionType.SYNC : IReplicationJob.ReplicationExecutionType.ASYNC;
        LSMIndexReplicationJob lSMIndexReplicationJob = new LSMIndexReplicationJob(this, ctx, componentFiles, operation, executionType, opType);
        try {
            this.diskBufferCache.getIOReplicationManager().submitJob((IReplicationJob)lSMIndexReplicationJob);
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    @Override
    public abstract void allocateMemoryComponents() throws HyracksDataException;

    @Override
    public boolean isMemoryComponentsAllocated() {
        return this.memoryComponentsAllocated;
    }

    @Override
    public boolean isDurable() {
        return this.durable;
    }

    @Override
    public ILSMMemoryComponent getCurrentMemoryComponent() {
        return this.memoryComponents.get(this.currentMutableComponentId.get());
    }

    @Override
    public int getCurrentMemoryComponentIndex() {
        return this.currentMutableComponentId.get();
    }

    @Override
    public List<ILSMMemoryComponent> getMemoryComponents() {
        return this.memoryComponents;
    }
}

