/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.snapshot;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;

@InterfaceAudience.Private
public class LsSnapshottableDir {
    public static void main(String[] argv) throws IOException {
        Configuration conf;
        FileSystem fs;
        String description = "LsSnapshottableDir: \n\tGet the list of snapshottable directories that are owned by the current user.\n\tReturn all the snapshottable directories if the current user is a super user.\n";
        if (argv.length != 0) {
            System.err.println("Usage: \n" + description);
            System.exit(1);
        }
        if (!((fs = FileSystem.get((Configuration)(conf = new Configuration()))) instanceof DistributedFileSystem)) {
            System.err.println("LsSnapshottableDir can only be used in DistributedFileSystem");
            System.exit(1);
        }
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        try {
            SnapshottableDirectoryStatus[] stats = dfs.getSnapshottableDirListing();
            SnapshottableDirectoryStatus.print(stats, System.out);
        }
        catch (IOException e) {
            String[] content = e.getLocalizedMessage().split("\n");
            System.err.println("lsSnapshottableDir: " + content[0]);
        }
    }
}

