/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree.impls;

import org.apache.hyracks.storage.am.btree.api.IPrefixSlotManager;
import org.apache.hyracks.storage.am.btree.frames.BTreeFieldPrefixNSMLeafFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;

public class FieldPrefixTupleReference
implements ITreeIndexTupleReference {
    private final ITreeIndexTupleReference helperTuple;
    private BTreeFieldPrefixNSMLeafFrame frame;
    private int prefixTupleStartOff;
    private int suffixTupleStartOff;
    private int numPrefixFields;
    private int fieldCount;

    public FieldPrefixTupleReference(ITreeIndexTupleReference helperTuple) {
        this.helperTuple = helperTuple;
        this.fieldCount = helperTuple.getFieldCount();
    }

    public void resetByTupleIndex(ITreeIndexFrame frame, int tupleIndex) {
        this.frame = (BTreeFieldPrefixNSMLeafFrame)frame;
        IPrefixSlotManager slotManager = this.frame.getSlotManager();
        int tupleSlotOff = slotManager.getTupleSlotOff(tupleIndex);
        int tupleSlot = this.frame.getBuffer().getInt(tupleSlotOff);
        int prefixSlotNum = slotManager.decodeFirstSlotField(tupleSlot);
        this.suffixTupleStartOff = slotManager.decodeSecondSlotField(tupleSlot);
        if (prefixSlotNum != 255) {
            int prefixSlotOff = slotManager.getPrefixSlotOff(prefixSlotNum);
            int prefixSlot = this.frame.getBuffer().getInt(prefixSlotOff);
            this.numPrefixFields = slotManager.decodeFirstSlotField(prefixSlot);
            this.prefixTupleStartOff = slotManager.decodeSecondSlotField(prefixSlot);
        } else {
            this.numPrefixFields = 0;
            this.prefixTupleStartOff = -1;
        }
    }

    public void setFieldCount(int fieldCount) {
        this.fieldCount = fieldCount;
    }

    public void setFieldCount(int fieldStartIndex, int fieldCount) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public byte[] getFieldData(int fIdx) {
        return this.frame.getBuffer().array();
    }

    public int getFieldLength(int fIdx) {
        if (fIdx < this.numPrefixFields) {
            this.helperTuple.setFieldCount(this.numPrefixFields);
            this.helperTuple.resetByTupleOffset(this.frame.getBuffer().array(), this.prefixTupleStartOff);
            return this.helperTuple.getFieldLength(fIdx);
        }
        this.helperTuple.setFieldCount(this.numPrefixFields, this.fieldCount - this.numPrefixFields);
        this.helperTuple.resetByTupleOffset(this.frame.getBuffer().array(), this.suffixTupleStartOff);
        return this.helperTuple.getFieldLength(fIdx - this.numPrefixFields);
    }

    public int getFieldStart(int fIdx) {
        if (fIdx < this.numPrefixFields) {
            this.helperTuple.setFieldCount(this.numPrefixFields);
            this.helperTuple.resetByTupleOffset(this.frame.getBuffer().array(), this.prefixTupleStartOff);
            return this.helperTuple.getFieldStart(fIdx);
        }
        this.helperTuple.setFieldCount(this.numPrefixFields, this.fieldCount - this.numPrefixFields);
        this.helperTuple.resetByTupleOffset(this.frame.getBuffer().array(), this.suffixTupleStartOff);
        return this.helperTuple.getFieldStart(fIdx - this.numPrefixFields);
    }

    public void resetByTupleOffset(byte[] buf, int tupleStartOffset) {
        throw new UnsupportedOperationException("Resetting this type of frame by offset is not supported.");
    }

    public int getTupleSize() {
        return this.getSuffixTupleSize() + this.getPrefixTupleSize();
    }

    public int getSuffixTupleSize() {
        this.helperTuple.setFieldCount(this.numPrefixFields, this.fieldCount - this.numPrefixFields);
        this.helperTuple.resetByTupleOffset(this.frame.getBuffer().array(), this.suffixTupleStartOff);
        return this.helperTuple.getTupleSize();
    }

    public int getPrefixTupleSize() {
        if (this.numPrefixFields == 0) {
            return 0;
        }
        this.helperTuple.setFieldCount(this.numPrefixFields);
        this.helperTuple.resetByTupleOffset(this.frame.getBuffer().array(), this.prefixTupleStartOff);
        return this.helperTuple.getTupleSize();
    }

    public int getNumPrefixFields() {
        return this.numPrefixFields;
    }
}

