/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Logger;

public class JSONUtil {
    private static final Logger LOGGER = Logger.getLogger(JSONUtil.class.getName());
    private static final String INDENT = "\t";
    private static final ObjectMapper SORTED_MAPPER = new ObjectMapper();

    private JSONUtil() {
    }

    public static String convertNode(JsonNode node) throws JsonProcessingException {
        Object obj = SORTED_MAPPER.treeToValue((TreeNode)node, Object.class);
        return SORTED_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
    }

    public static String indent(String str, int initialIndent) {
        ObjectMapper om = new ObjectMapper();
        try {
            return JSONUtil.appendObj(new StringBuilder(), om.readTree(str), initialIndent).toString();
        }
        catch (IOException e) {
            LOGGER.finest(String.valueOf(e));
            LOGGER.finest("Could not indent JSON string, returning the input string: " + str);
            return str;
        }
    }

    private static StringBuilder appendOrd(StringBuilder sb, JsonNode o, int indent) {
        if (o.isObject()) {
            return JSONUtil.appendObj(sb, o, indent);
        }
        if (o.isArray()) {
            return JSONUtil.appendAry(sb, o, indent);
        }
        if (o.isTextual()) {
            return JSONUtil.quoteAndEscape(sb, o.asText());
        }
        if (o.isNull() || o.isIntegralNumber() || o.isBoolean()) {
            return sb.append(String.valueOf(o));
        }
        throw new UnsupportedOperationException(o.getClass().getSimpleName());
    }

    private static StringBuilder appendObj(StringBuilder builder, JsonNode jobj, int indent) {
        StringBuilder sb = builder.append("{\n");
        boolean first = true;
        Iterator it = jobj.iterator();
        while (it.hasNext()) {
            String key = ((JsonNode)it.next()).asText();
            if (first) {
                first = false;
            } else {
                sb = sb.append(",\n");
            }
            sb = JSONUtil.indent(sb, indent + 1);
            sb = JSONUtil.quote(sb, key);
            sb = sb.append(": ");
            if (jobj.get(key).isArray()) {
                sb = JSONUtil.appendAry(sb, jobj.get(key), indent + 1);
                continue;
            }
            if (jobj.get(key).isObject()) {
                sb = JSONUtil.appendObj(sb, jobj.get(key), indent + 1);
                continue;
            }
            sb = JSONUtil.appendOrd(sb, jobj.get(key), indent + 1);
        }
        sb = sb.append("\n");
        return JSONUtil.indent(sb, indent).append("}");
    }

    private static StringBuilder appendAry(StringBuilder builder, JsonNode jarr, int indent) {
        StringBuilder sb = builder.append("[\n");
        for (int i = 0; i < jarr.size(); ++i) {
            if (i > 0) {
                sb = sb.append(",\n");
            }
            sb = JSONUtil.indent(sb, indent + 1);
            sb = jarr.get(i).isArray() ? JSONUtil.appendAry(sb, jarr.get(i), indent + 1) : (jarr.get(i).isObject() ? JSONUtil.appendObj(sb, jarr.get(i), indent + 1) : JSONUtil.appendOrd(sb, jarr.get(i), indent + 1));
        }
        sb = sb.append("\n");
        return JSONUtil.indent(sb, indent).append("]");
    }

    private static StringBuilder quote(StringBuilder sb, String str) {
        return sb.append('\"').append(str).append('\"');
    }

    private static StringBuilder indent(StringBuilder sb, int i) {
        for (int indent = i; indent > 0; --indent) {
            sb.append(INDENT);
        }
        return sb;
    }

    public static String quoteAndEscape(String str) {
        return JSONUtil.quoteAndEscape(new StringBuilder(), str).toString();
    }

    private static StringBuilder quoteAndEscape(StringBuilder sb, String str) {
        return JSONUtil.escape(sb.append('\"'), str).append('\"');
    }

    public static String escape(String str) {
        return JSONUtil.escape(new StringBuilder(), str).toString();
    }

    public static StringBuilder escape(StringBuilder sb, String str) {
        for (int i = 0; i < str.length(); ++i) {
            JSONUtil.appendEsc(sb, str.charAt(i));
        }
        return sb;
    }

    private static StringBuilder appendEsc(StringBuilder sb, char c) {
        CharSequence cs = JSONUtil.esc(c);
        return cs != null ? sb.append(cs) : sb.append(c);
    }

    public static CharSequence esc(char c) {
        switch (c) {
            case '\"': {
                return "\\\"";
            }
            case '\\': {
                return "\\\\";
            }
            case '/': {
                return "\\/";
            }
            case '\b': {
                return "\\b";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
        }
        return null;
    }

    static {
        SORTED_MAPPER.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
    }
}

