/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.impls;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeDiskComponent;

public class LSMRTreeMergeOperation
implements ILSMIOOperation {
    private final ILSMIndexAccessor accessor;
    private final List<ILSMComponent> mergingComponents;
    private final ITreeIndexCursor cursor;
    private final FileReference rtreeMergeTarget;
    private final FileReference btreeMergeTarget;
    private final FileReference bloomFilterMergeTarget;
    private final ILSMIOOperationCallback callback;
    private final String indexIdentifier;
    private boolean keepDeletedTuples;

    public LSMRTreeMergeOperation(ILSMIndexAccessor accessor, List<ILSMComponent> mergingComponents, ITreeIndexCursor cursor, FileReference rtreeMergeTarget, FileReference btreeMergeTarget, FileReference bloomFilterMergeTarget, ILSMIOOperationCallback callback, String indexIdentifier) {
        this.accessor = accessor;
        this.mergingComponents = mergingComponents;
        this.cursor = cursor;
        this.rtreeMergeTarget = rtreeMergeTarget;
        this.btreeMergeTarget = btreeMergeTarget;
        this.bloomFilterMergeTarget = bloomFilterMergeTarget;
        this.callback = callback;
        this.indexIdentifier = indexIdentifier;
    }

    public Set<IODeviceHandle> getReadDevices() {
        HashSet<IODeviceHandle> devs = new HashSet<IODeviceHandle>();
        for (ILSMComponent o : this.mergingComponents) {
            LSMRTreeDiskComponent component = (LSMRTreeDiskComponent)o;
            devs.add(component.getRTree().getFileReference().getDeviceHandle());
            if (component.getBTree() == null) continue;
            devs.add(component.getBTree().getFileReference().getDeviceHandle());
            devs.add(component.getBloomFilter().getFileReference().getDeviceHandle());
        }
        return devs;
    }

    public Set<IODeviceHandle> getWriteDevices() {
        HashSet<IODeviceHandle> devs = new HashSet<IODeviceHandle>();
        devs.add(this.rtreeMergeTarget.getDeviceHandle());
        if (this.btreeMergeTarget != null) {
            devs.add(this.btreeMergeTarget.getDeviceHandle());
            devs.add(this.bloomFilterMergeTarget.getDeviceHandle());
        }
        return devs;
    }

    public Boolean call() throws HyracksDataException, IndexException {
        this.accessor.merge((ILSMIOOperation)this);
        return true;
    }

    public ILSMIOOperationCallback getCallback() {
        return this.callback;
    }

    public FileReference getRTreeMergeTarget() {
        return this.rtreeMergeTarget;
    }

    public FileReference getBTreeMergeTarget() {
        return this.btreeMergeTarget;
    }

    public FileReference getBloomFilterMergeTarget() {
        return this.bloomFilterMergeTarget;
    }

    public ITreeIndexCursor getCursor() {
        return this.cursor;
    }

    public List<ILSMComponent> getMergingComponents() {
        return this.mergingComponents;
    }

    public String getIndexUniqueIdentifier() {
        return this.indexIdentifier;
    }

    public ILSMIOOperation.LSMIOOpertionType getIOOpertionType() {
        return ILSMIOOperation.LSMIOOpertionType.MERGE;
    }

    public boolean isKeepDeletedTuples() {
        return this.keepDeletedTuples;
    }

    public void setKeepDeletedTuples(boolean keepDeletedTuples) {
        this.keepDeletedTuples = keepDeletedTuples;
    }
}

