/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server.utils;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.BaseRequest;
import org.apache.hyracks.http.server.PostRequest;

public class HttpUtil {
    private HttpUtil() {
    }

    public static String getParameter(Map<String, List<String>> parameters, CharSequence name) {
        List<String> parameter = parameters.get(name);
        if (parameter == null) {
            return null;
        }
        if (parameter.size() == 1) {
            return parameter.get(0);
        }
        StringBuilder aString = new StringBuilder(parameter.get(0));
        for (int i = 1; i < parameter.size(); ++i) {
            aString.append(",").append(parameter.get(i));
        }
        return aString.toString();
    }

    public static IServletRequest toServletRequest(FullHttpRequest request) throws IOException {
        return request.method() == HttpMethod.POST ? PostRequest.create(request) : BaseRequest.create(request);
    }

    public static void setContentType(IServletResponse response, String type, String charset) throws IOException {
        response.setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, type + "; charset=" + charset);
    }

    public static void setContentType(IServletResponse response, String type) throws IOException {
        response.setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, type);
    }

    public static String mime(String extension) {
        switch (extension) {
            case ".png": {
                return "image/png";
            }
            case ".eot": {
                return "application/vnd.ms-fontobject";
            }
            case ".svg": {
                return "image/svg+xml\t";
            }
            case ".ttf": {
                return "application/x-font-ttf";
            }
            case ".woff": 
            case ".woff2": {
                return "application/x-font-woff";
            }
            case ".html": {
                return "text/html";
            }
            case ".css": {
                return "text/css";
            }
            case ".txt": {
                return "text/plain";
            }
            case ".ico": {
                return "image/x-icon";
            }
            case ".js": {
                return "application/javascript";
            }
        }
        return null;
    }

    public static class ContentType {
        public static final String APPLICATION_ADM = "application/x-adm";
        public static final String APPLICATION_JSON = "application/json";
        public static final String CSV = "text/csv";
        public static final String IMG_PNG = "image/png";
        public static final String TEXT_HTML = "text/html";
        public static final String TEXT_PLAIN = "text/plain";

        private ContentType() {
        }
    }

    public static class Encoding {
        public static final String UTF8 = "utf-8";

        private Encoding() {
        }
    }
}

