/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.MixedAttribute;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.server.BaseRequest;
import org.apache.hyracks.http.server.utils.HttpUtil;

public class PostRequest
extends BaseRequest
implements IServletRequest {
    private static final Logger LOGGER = Logger.getLogger(PostRequest.class.getName());
    private final List<String> names;
    private final List<String> values;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IServletRequest create(FullHttpRequest request) throws IOException {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        HttpPostRequestDecoder decoder = null;
        try {
            decoder = new HttpPostRequestDecoder((HttpRequest)request);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to decode a post message. Fix the API not to have queries as POST body", e);
        }
        if (decoder != null) {
            try {
                List bodyHttpDatas = decoder.getBodyHttpDatas();
                for (InterfaceHttpData data : bodyHttpDatas) {
                    if (!data.getHttpDataType().equals((Object)InterfaceHttpData.HttpDataType.Attribute)) continue;
                    MixedAttribute attr = (MixedAttribute)data;
                    names.add(data.getName());
                    values.add(attr.getValue());
                }
            }
            finally {
                decoder.destroy();
            }
        }
        return new PostRequest(request, new QueryStringDecoder(request.uri()).parameters(), names, values);
    }

    protected PostRequest(FullHttpRequest request, Map<String, List<String>> parameters, List<String> names, List<String> values) {
        super(request, parameters);
        this.names = names;
        this.values = values;
    }

    @Override
    public String getParameter(CharSequence name) {
        for (int i = 0; i < this.names.size(); ++i) {
            if (!name.equals(this.names.get(i))) continue;
            return this.values.get(i);
        }
        return HttpUtil.getParameter(this.parameters, name);
    }
}

