/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import org.apache.hyracks.http.server.HttpServer;
import org.apache.hyracks.http.server.HttpServerHandler;

public class HttpServerInitializer
extends ChannelInitializer<SocketChannel> {
    private static final int MAX_REQUEST_CHUNK_SIZE = 262144;
    private static final int MAX_REQUEST_HEADER_SIZE = 262144;
    private static final int MAX_REQUEST_INITIAL_LINE_LENGTH = 131072;
    private static final int RESPONSE_CHUNK_SIZE = 4096;
    private HttpServer server;

    public HttpServerInitializer(HttpServer server) {
        this.server = server;
    }

    public void initChannel(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        p.addLast(new ChannelHandler[]{new HttpRequestDecoder(131072, 262144, 262144)});
        p.addLast(new ChannelHandler[]{new HttpResponseEncoder()});
        p.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
        p.addLast(new ChannelHandler[]{new HttpServerHandler(this.server, 4096)});
    }
}

