/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.http.api.IServlet;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.utils.HttpUtil;

public abstract class AbstractServlet
implements IServlet {
    private static final Logger LOGGER = Logger.getLogger(AbstractServlet.class.getName());
    protected final String[] paths;
    protected final ConcurrentMap<String, Object> ctx;
    private final int[] trims;

    public AbstractServlet(ConcurrentMap<String, Object> ctx, String ... paths) {
        this.paths = paths;
        this.ctx = ctx;
        this.trims = new int[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            this.trims[i] = path.endsWith("/*") ? path.indexOf("/*") : (path.endsWith("/") ? path.length() - 1 : path.length());
        }
    }

    @Override
    public String[] getPaths() {
        return this.paths;
    }

    @Override
    public ConcurrentMap<String, Object> ctx() {
        return this.ctx;
    }

    @Override
    public void handle(IServletRequest request, IServletResponse response) {
        try {
            HttpMethod method = request.getHttpRequest().method();
            if (HttpMethod.GET.equals((Object)method)) {
                this.get(request, response);
            } else if (HttpMethod.HEAD.equals((Object)method)) {
                this.head(request, response);
            } else if (HttpMethod.POST.equals((Object)method)) {
                this.post(request, response);
            } else if (HttpMethod.PUT.equals((Object)method)) {
                this.put(request, response);
            } else if (HttpMethod.DELETE.equals((Object)method)) {
                this.delete(request, response);
            } else if (HttpMethod.OPTIONS.equals((Object)method)) {
                this.options(request, response);
            } else {
                this.notAllowed(method, response);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unhandled exception", e);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    protected void notAllowed(HttpMethod method, IServletResponse response) throws IOException {
        response.setStatus(HttpResponseStatus.METHOD_NOT_ALLOWED);
        HttpUtil.setContentType(response, "text/plain", "utf-8");
        response.writer().write("Method " + method + " not allowed for the requested resource.\n");
    }

    protected void get(IServletRequest request, IServletResponse response) throws Exception {
        this.notAllowed(HttpMethod.GET, response);
    }

    protected void head(IServletRequest request, IServletResponse response) throws Exception {
        this.notAllowed(HttpMethod.HEAD, response);
    }

    protected void post(IServletRequest request, IServletResponse response) throws Exception {
        this.notAllowed(HttpMethod.POST, response);
    }

    protected void put(IServletRequest request, IServletResponse response) throws Exception {
        this.notAllowed(HttpMethod.PUT, response);
    }

    protected void delete(IServletRequest request, IServletResponse response) throws Exception {
        this.notAllowed(HttpMethod.DELETE, response);
    }

    protected void options(IServletRequest request, IServletResponse response) throws Exception {
        this.notAllowed(HttpMethod.OPTIONS, response);
    }

    public String host(IServletRequest request) {
        return request.getHttpRequest().headers().get((CharSequence)HttpHeaderNames.HOST);
    }

    public String localPath(IServletRequest request) {
        String uri = request.getHttpRequest().uri();
        return uri.substring(this.trim(uri));
    }

    public String servletPath(IServletRequest request) {
        String uri = request.getHttpRequest().uri();
        return uri.substring(0, this.trim(uri));
    }

    protected int trim(String uri) {
        int trim = -1;
        if (this.paths.length > 1) {
            for (int i = 0; i < this.paths.length; ++i) {
                String path;
                String string = path = this.paths[i].indexOf(42) >= 0 ? this.paths[i].substring(0, this.paths[i].indexOf(42)) : this.paths[i];
                if (uri.indexOf(path) != 0) continue;
                trim = this.trims[i];
                break;
            }
        } else {
            trim = this.trims[0];
        }
        return trim;
    }

    public String toString() {
        return this.getClass().getSimpleName() + Arrays.toString(this.paths);
    }
}

