/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.utils;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.config.CompilerProperties;
import org.apache.asterix.runtime.utils.AppContextInfo;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.cluster.INodeManager;

public class RuntimeUtils {
    private RuntimeUtils() {
    }

    public static Set<String> getNodeControllersOnIP(InetAddress ipAddress) throws HyracksDataException {
        Map<InetAddress, Set<String>> nodeControllerInfo = RuntimeUtils.getNodeControllerMap();
        return nodeControllerInfo.get(ipAddress);
    }

    public static List<String> getAllNodeControllers() throws HyracksDataException {
        Collection<Set<String>> nodeControllersCollection = RuntimeUtils.getNodeControllerMap().values();
        ArrayList<String> nodeControllers = new ArrayList<String>();
        for (Set<String> ncCollection : nodeControllersCollection) {
            nodeControllers.addAll(ncCollection);
        }
        return nodeControllers;
    }

    public static Map<InetAddress, Set<String>> getNodeControllerMap() throws HyracksDataException {
        HashMap<InetAddress, Set<String>> map = new HashMap<InetAddress, Set<String>>();
        AppContextInfo.INSTANCE.getCCServiceContext().getCCContext().getIPAddressNodeMap(map);
        return map;
    }

    public static void getNodeControllerMap(Map<InetAddress, Set<String>> map) {
        ClusterControllerService ccs = (ClusterControllerService)AppContextInfo.INSTANCE.getCCServiceContext().getControllerService();
        INodeManager nodeManager = ccs.getNodeManager();
        map.putAll(nodeManager.getIpAddressNodeNameMap());
    }

    public static JobSpecification createJobSpecification() {
        CompilerProperties compilerProperties = AppContextInfo.INSTANCE.getCompilerProperties();
        int frameSize = compilerProperties.getFrameSize();
        return new JobSpecification(frameSize);
    }
}

