/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.transaction;

import java.util.concurrent.LinkedBlockingQueue;
import org.apache.asterix.common.messaging.api.IApplicationMessage;
import org.apache.asterix.common.messaging.api.INCMessageBroker;
import org.apache.asterix.runtime.message.ResourceIdRequestMessage;
import org.apache.asterix.runtime.message.ResourceIdRequestResponseMessage;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.common.file.IResourceIdFactory;

public class GlobalResourceIdFactory
implements IResourceIdFactory {
    private final INCServiceContext serviceCtx;
    private final LinkedBlockingQueue<ResourceIdRequestResponseMessage> resourceIdResponseQ;
    private final String nodeId;

    public GlobalResourceIdFactory(INCServiceContext serviceCtx) {
        this.serviceCtx = serviceCtx;
        this.resourceIdResponseQ = new LinkedBlockingQueue();
        this.nodeId = serviceCtx.getNodeId();
    }

    public void addNewIds(ResourceIdRequestResponseMessage resourceIdResponse) throws InterruptedException {
        this.resourceIdResponseQ.put(resourceIdResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createId() throws HyracksDataException {
        try {
            ResourceIdRequestResponseMessage reponse = null;
            if (!this.resourceIdResponseQ.isEmpty()) {
                LinkedBlockingQueue<ResourceIdRequestResponseMessage> linkedBlockingQueue = this.resourceIdResponseQ;
                synchronized (linkedBlockingQueue) {
                    if (!this.resourceIdResponseQ.isEmpty()) {
                        reponse = this.resourceIdResponseQ.take();
                    }
                }
            }
            if (reponse == null || reponse.getException() != null) {
                ResourceIdRequestMessage msg = new ResourceIdRequestMessage(this.nodeId);
                ((INCMessageBroker)this.serviceCtx.getMessageBroker()).sendMessageToCC((IApplicationMessage)msg);
                reponse = this.resourceIdResponseQ.take();
                if (reponse.getException() != null) {
                    throw new HyracksDataException(reponse.getException().getMessage());
                }
            }
            return reponse.getResourceId();
        }
        catch (Exception e) {
            throw new HyracksDataException((Throwable)e);
        }
    }
}

