/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.operators;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.asterix.common.api.IAppRuntimeContext;
import org.apache.asterix.common.dataflow.LSMIndexUtil;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.asterix.common.transactions.PrimaryIndexLogMarkerCallback;
import org.apache.asterix.om.pointables.nonvisitor.ARecordPointable;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.transaction.management.opcallbacks.AbstractIndexModificationOperationCallback;
import org.apache.asterix.transaction.management.opcallbacks.LockThenSearchOperationCallback;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.IMissingWriter;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.utils.TaskUtil;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.btree.util.BTreeUtils;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.dataflow.IIndexOperatorDescriptor;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.am.common.tuples.PermutingFrameTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.IFrameOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.IFrameOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.dataflow.LSMIndexInsertUpdateDeleteOperatorNodePushable;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMTreeIndexAccessor;

public class LSMPrimaryUpsertOperatorNodePushable
extends LSMIndexInsertUpdateDeleteOperatorNodePushable {
    private final PermutingFrameTupleReference key;
    private MultiComparator keySearchCmp;
    private ArrayTupleBuilder missingTupleBuilder;
    private final IMissingWriter missingWriter;
    private ArrayTupleBuilder tb;
    private DataOutput dos;
    private RangePredicate searchPred;
    private IIndexCursor cursor;
    private ITupleReference prevTuple;
    private final int numOfPrimaryKeys;
    boolean isFiltered = false;
    private final ArrayTupleReference prevTupleWithFilter = new ArrayTupleReference();
    private ArrayTupleBuilder prevRecWithPKWithFilterValue;
    private ARecordType recordType;
    private int presetFieldIndex = -1;
    private ARecordPointable recPointable;
    private DataOutput prevDos;
    private final boolean hasMeta;
    private final int filterFieldIndex;
    private final int metaFieldIndex;
    private LockThenSearchOperationCallback searchCallback;
    private IFrameOperationCallback frameOpCallback;
    private final IFrameOperationCallbackFactory frameOpCallbackFactory;
    private AbstractIndexModificationOperationCallback abstractModCallback;

    public LSMPrimaryUpsertOperatorNodePushable(IIndexOperatorDescriptor opDesc, IHyracksTaskContext ctx, int partition, int[] fieldPermutation, IRecordDescriptorProvider recordDescProvider, int numOfPrimaryKeys, ARecordType recordType, int filterFieldIndex, IFrameOperationCallbackFactory frameOpCallbackFactory) throws HyracksDataException {
        super(opDesc, ctx, partition, fieldPermutation, recordDescProvider, IndexOperation.UPSERT);
        this.key = new PermutingFrameTupleReference();
        this.numOfPrimaryKeys = numOfPrimaryKeys;
        this.frameOpCallbackFactory = frameOpCallbackFactory;
        this.missingWriter = opDesc.getMissingWriterFactory().createMissingWriter();
        int[] searchKeyPermutations = new int[numOfPrimaryKeys];
        for (int i = 0; i < searchKeyPermutations.length; ++i) {
            searchKeyPermutations[i] = fieldPermutation[i];
        }
        this.key.setFieldPermutation(searchKeyPermutations);
        this.hasMeta = fieldPermutation.length > numOfPrimaryKeys + 1 && (filterFieldIndex < 0 || filterFieldIndex >= 0 && fieldPermutation.length > numOfPrimaryKeys + 2);
        this.metaFieldIndex = numOfPrimaryKeys + 1;
        this.filterFieldIndex = numOfPrimaryKeys + (this.hasMeta ? 2 : 1);
        if (filterFieldIndex >= 0) {
            this.isFiltered = true;
            this.recordType = recordType;
            this.presetFieldIndex = filterFieldIndex;
            this.recPointable = ARecordPointable.FACTORY.createPointable();
            this.prevRecWithPKWithFilterValue = new ArrayTupleBuilder(fieldPermutation.length + (this.hasMeta ? 1 : 0));
            this.prevDos = this.prevRecWithPKWithFilterValue.getDataOutput();
        }
    }

    public void open() throws HyracksDataException {
        RecordDescriptor inputRecDesc = this.recordDescProvider.getInputRecordDescriptor(this.opDesc.getActivityId(), 0);
        this.accessor = new FrameTupleAccessor(inputRecDesc);
        this.writeBuffer = new VSizeFrame((IHyracksFrameMgrContext)this.ctx);
        this.writer.open();
        this.indexHelper.open();
        this.index = this.indexHelper.getIndexInstance();
        try {
            if (this.ctx.getSharedObject() != null) {
                PrimaryIndexLogMarkerCallback callback = new PrimaryIndexLogMarkerCallback((ILSMIndex)((AbstractLSMIndex)this.index));
                TaskUtil.putInSharedMap((String)"MARKER_CALLBACK", (Object)callback, (IHyracksTaskContext)this.ctx);
            }
            this.missingTupleBuilder = new ArrayTupleBuilder(1);
            DataOutput out = this.missingTupleBuilder.getDataOutput();
            try {
                this.missingWriter.writeMissing(out);
            }
            catch (IOException e) {
                throw new HyracksDataException((Throwable)e);
            }
            this.missingTupleBuilder.addFieldEndOffset();
            this.searchPred = this.createSearchPredicate();
            this.tb = new ArrayTupleBuilder(this.recordDesc.getFieldCount());
            this.dos = this.tb.getDataOutput();
            this.appender = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)this.ctx), true);
            this.modCallback = this.opDesc.getModificationOpCallbackFactory().createModificationOperationCallback(this.indexHelper.getResource(), this.ctx, (IOperatorNodePushable)this);
            this.abstractModCallback = (AbstractIndexModificationOperationCallback)this.modCallback;
            this.searchCallback = (LockThenSearchOperationCallback)this.opDesc.getSearchOpCallbackFactory().createSearchOperationCallback(this.indexHelper.getResource().getId(), this.ctx, (IOperatorNodePushable)this);
            this.indexAccessor = this.index.createAccessor((IModificationOperationCallback)this.abstractModCallback, (ISearchOperationCallback)this.searchCallback);
            this.cursor = this.indexAccessor.createSearchCursor(false);
            this.frameTuple = new FrameTupleReference();
            IAppRuntimeContext appCtx = (IAppRuntimeContext)this.ctx.getJobletContext().getServiceContext().getApplicationContext();
            LSMIndexUtil.checkAndSetFirstLSN((AbstractLSMIndex)((AbstractLSMIndex)this.index), (ILogManager)appCtx.getTransactionSubsystem().getLogManager());
            this.frameOpCallback = this.frameOpCallbackFactory.createFrameOperationCallback(this.ctx, (ILSMIndexAccessor)this.indexAccessor);
        }
        catch (Exception e) {
            this.indexHelper.close();
            throw new HyracksDataException((Throwable)e);
        }
    }

    private void resetSearchPredicate(int tupleIndex) {
        this.key.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
        this.searchPred.reset((ITupleReference)this.key, (ITupleReference)this.key, true, true, this.keySearchCmp, this.keySearchCmp);
    }

    private void writeOutput(int tupleIndex, boolean recordWasInserted, boolean recordWasDeleted) throws IOException {
        if (recordWasInserted || recordWasDeleted) {
            this.frameTuple.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
            for (int i = 0; i < this.frameTuple.getFieldCount(); ++i) {
                this.dos.write(this.frameTuple.getFieldData(i), this.frameTuple.getFieldStart(i), this.frameTuple.getFieldLength(i));
                this.tb.addFieldEndOffset();
            }
            FrameUtils.appendToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)this.appender, (int[])this.tb.getFieldEndOffsets(), (byte[])this.tb.getByteArray(), (int)0, (int)this.tb.getSize());
        } else {
            try {
                this.searchCallback.release();
            }
            catch (ACIDException e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
    }

    public static boolean isNull(ITupleReference t1, int field) {
        return t1.getFieldData(field)[t1.getFieldStart(field)] == ATypeTag.SERIALIZED_MISSING_TYPE_TAG;
    }

    private void addNullField() throws IOException {
        this.dos.write(this.missingTupleBuilder.getByteArray());
        this.tb.addFieldEndOffset();
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        LSMTreeIndexAccessor lsmAccessor = (LSMTreeIndexAccessor)this.indexAccessor;
        int tupleCount = this.accessor.getTupleCount();
        boolean firstModification = true;
        try {
            for (int i = 0; i < tupleCount; ++i) {
                this.tb.reset();
                boolean recordWasInserted = false;
                this.tuple.reset((IFrameTupleAccessor)this.accessor, i);
                this.resetSearchPredicate(i);
                lsmAccessor.search(this.cursor, (ISearchPredicate)this.searchPred);
                if (this.cursor.hasNext()) {
                    this.cursor.next();
                    this.prevTuple = this.cursor.getTuple();
                    this.cursor.reset();
                    if (this.isFiltered) {
                        this.prevTuple = this.getPrevTupleWithFilter(this.prevTuple);
                    }
                    this.dos.write(this.prevTuple.getFieldData(this.numOfPrimaryKeys), this.prevTuple.getFieldStart(this.numOfPrimaryKeys), this.prevTuple.getFieldLength(this.numOfPrimaryKeys));
                    this.tb.addFieldEndOffset();
                    if (this.hasMeta) {
                        this.dos.write(this.prevTuple.getFieldData(this.metaFieldIndex), this.prevTuple.getFieldStart(this.metaFieldIndex), this.prevTuple.getFieldLength(this.metaFieldIndex));
                        this.tb.addFieldEndOffset();
                    }
                    if (this.isFiltered) {
                        this.dos.write(this.prevTuple.getFieldData(this.filterFieldIndex), this.prevTuple.getFieldStart(this.filterFieldIndex), this.prevTuple.getFieldLength(this.filterFieldIndex));
                        this.tb.addFieldEndOffset();
                    }
                    if (LSMPrimaryUpsertOperatorNodePushable.isNull((ITupleReference)this.tuple, this.numOfPrimaryKeys)) {
                        this.abstractModCallback.setOp(AbstractIndexModificationOperationCallback.Operation.DELETE);
                        if (firstModification) {
                            lsmAccessor.delete(this.prevTuple);
                            firstModification = false;
                        } else {
                            lsmAccessor.forceDelete(this.prevTuple);
                        }
                    }
                } else {
                    this.prevTuple = null;
                    this.addNullField();
                    if (this.hasMeta) {
                        this.addNullField();
                    }
                    if (this.isFiltered) {
                        this.addNullField();
                    }
                    this.cursor.reset();
                }
                if (!LSMPrimaryUpsertOperatorNodePushable.isNull((ITupleReference)this.tuple, this.numOfPrimaryKeys)) {
                    this.abstractModCallback.setOp(AbstractIndexModificationOperationCallback.Operation.UPSERT);
                    if (firstModification) {
                        lsmAccessor.upsert((ITupleReference)this.tuple);
                        firstModification = false;
                    } else {
                        lsmAccessor.forceUpsert((ITupleReference)this.tuple);
                    }
                    recordWasInserted = true;
                }
                this.writeOutput(i, recordWasInserted, this.prevTuple != null);
            }
            this.frameOpCallback.frameCompleted(!firstModification);
            this.appender.write(this.writer, true);
        }
        catch (IOException | AsterixException | IndexException e) {
            throw new HyracksDataException(e);
        }
    }

    public void flushPartialFrame() throws HyracksDataException {
        this.appender.write(this.writer, true);
    }

    private ITupleReference getPrevTupleWithFilter(ITupleReference prevTuple) throws IOException, AsterixException {
        this.prevRecWithPKWithFilterValue.reset();
        for (int i = 0; i < prevTuple.getFieldCount(); ++i) {
            this.prevDos.write(prevTuple.getFieldData(i), prevTuple.getFieldStart(i), prevTuple.getFieldLength(i));
            this.prevRecWithPKWithFilterValue.addFieldEndOffset();
        }
        this.recPointable.set(prevTuple.getFieldData(this.numOfPrimaryKeys), prevTuple.getFieldStart(this.numOfPrimaryKeys), prevTuple.getFieldLength(this.numOfPrimaryKeys));
        byte tag = this.recPointable.getClosedFieldType(this.recordType, this.presetFieldIndex).getTypeTag().serialize();
        this.prevDos.write(tag);
        this.prevDos.write(this.recPointable.getByteArray(), this.recPointable.getClosedFieldOffset(this.recordType, this.presetFieldIndex), this.recPointable.getClosedFieldSize(this.recordType, this.presetFieldIndex));
        this.prevRecWithPKWithFilterValue.addFieldEndOffset();
        this.prevTupleWithFilter.reset(this.prevRecWithPKWithFilterValue.getFieldEndOffsets(), this.prevRecWithPKWithFilterValue.getByteArray());
        return this.prevTupleWithFilter;
    }

    private RangePredicate createSearchPredicate() {
        this.keySearchCmp = BTreeUtils.getSearchMultiComparator((IBinaryComparatorFactory[])((ITreeIndex)this.index).getComparatorFactories(), (ITupleReference)this.key);
        return new RangePredicate((ITupleReference)this.key, (ITupleReference)this.key, true, true, this.keySearchCmp, this.keySearchCmp, null, null);
    }

    public void close() throws HyracksDataException {
        try {
            try {
                this.cursor.close();
            }
            finally {
                this.writer.close();
            }
        }
        finally {
            this.indexHelper.close();
        }
    }

    public void fail() throws HyracksDataException {
        this.writer.fail();
    }

    public void flush() throws HyracksDataException {
    }
}

