/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.message;

import org.apache.asterix.common.api.IAppRuntimeContext;
import org.apache.asterix.common.messaging.api.IApplicationMessage;
import org.apache.asterix.common.replication.Replica;
import org.apache.asterix.common.replication.ReplicaEvent;
import org.apache.asterix.event.schema.cluster.Node;
import org.apache.hyracks.api.application.IClusterLifecycleListener;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.service.IControllerService;

public class ReplicaEventMessage
implements IApplicationMessage {
    private static final long serialVersionUID = 1L;
    private final String nodeId;
    private final IClusterLifecycleListener.ClusterEventType event;
    private final String nodeIPAddress;

    public ReplicaEventMessage(String nodeId, String nodeIPAddress, IClusterLifecycleListener.ClusterEventType event) {
        this.nodeId = nodeId;
        this.nodeIPAddress = nodeIPAddress;
        this.event = event;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public IClusterLifecycleListener.ClusterEventType getEvent() {
        return this.event;
    }

    public String getNodeIPAddress() {
        return this.nodeIPAddress;
    }

    public void handle(IControllerService cs) throws HyracksDataException, InterruptedException {
        IAppRuntimeContext appContext = (IAppRuntimeContext)cs.getApplicationContext();
        Node node = new Node();
        node.setId(this.nodeId);
        node.setClusterIp(this.nodeIPAddress);
        Replica replica = new Replica(node);
        appContext.getReplicationManager().reportReplicaEvent(new ReplicaEvent(replica, this.event));
    }

    public String toString() {
        return ReplicaEventMessage.class.getSimpleName();
    }
}

