/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.staticcodegen;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.runtime.evaluators.staticcodegen.MethodIdentifier;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EvaluatorMissingCheckVisitor
extends ClassVisitor {
    private static final String EVALUATE_DESC = "(Lorg/apache/hyracks/dataflow/common/data/accessors/IFrameTupleReference;Lorg/apache/hyracks/data/std/api/IPointable;)V";
    private static final String EVALUATE = "evaluate";
    private static final MethodIdentifier METHOD_IDENTIFIER = new MethodIdentifier("evaluate", "(Lorg/apache/hyracks/dataflow/common/data/accessors/IFrameTupleReference;Lorg/apache/hyracks/data/std/api/IPointable;)V", null);
    private static final String TYPE_CHECKER_CLASS = "org/apache/asterix/runtime/evaluators/staticcodegen/TypeChecker";
    private static final String TYPE_CHECKER_DESC = "Lorg/apache/asterix/runtime/evaluators/staticcodegen/TypeChecker;";
    private static final String TYPE_CHECKER_NAME = "typeChecker";
    private static final String IS_MISSING = "isMissing";
    private static final String TYPECHECK_METHOD_DESC = "(Lorg/apache/hyracks/data/std/api/IPointable;Lorg/apache/hyracks/data/std/api/IPointable;)Z";
    private static final String CONSTRUCTOR = "<init>";
    private String className = null;
    private Label lastAddedLabel = null;

    public EvaluatorMissingCheckVisitor(ClassVisitor downStreamVisitor) {
        super(327680, downStreamVisitor);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (this.cv != null) {
            this.cv.visit(version, access, name, signature, superName, interfaces);
        }
        this.className = name;
    }

    public void visitEnd() {
        if (this.cv != null) {
            this.cv.visitField(18, TYPE_CHECKER_NAME, TYPE_CHECKER_DESC, null, null);
            this.cv.visitEnd();
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if (!METHOD_IDENTIFIER.equals(new MethodIdentifier(name, desc, signature)) && !name.equals(CONSTRUCTOR)) {
            return mv;
        }
        if (name.equals(CONSTRUCTOR) && mv != null) {
            return new ConstructorVisitor(327680, mv);
        }
        if (mv != null) {
            return new InjectMissingCheckVisitor(327680, mv);
        }
        return null;
    }

    Label getLastAddedLabel() {
        return this.lastAddedLabel;
    }

    class InjectMissingCheckVisitor
    extends MethodVisitor {
        private FieldInsnNode fieldAccessNode;
        private List<AbstractInsnNode> instructionsAfterFieldAccess;
        private boolean updateToNextLabel;

        public InjectMissingCheckVisitor(int opcode, MethodVisitor mv) {
            super(opcode, mv);
            this.fieldAccessNode = null;
            this.instructionsAfterFieldAccess = new ArrayList<AbstractInsnNode>();
            this.updateToNextLabel = false;
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            this.mv.visitFieldInsn(opcode, owner, name, desc);
            this.fieldAccessNode = new FieldInsnNode(opcode, owner, name, desc);
            this.instructionsAfterFieldAccess.clear();
        }

        public void visitIincInsn(int var, int increment) {
            if (this.fieldAccessNode != null) {
                this.instructionsAfterFieldAccess.add((AbstractInsnNode)new IincInsnNode(var, increment));
            }
            super.visitIincInsn(var, increment);
        }

        public void visitInsn(int opcode) {
            if (this.fieldAccessNode != null) {
                this.instructionsAfterFieldAccess.add((AbstractInsnNode)new InsnNode(opcode));
            }
            super.visitInsn(opcode);
        }

        public void visitIntInsn(int opcode, int operand) {
            if (this.fieldAccessNode != null) {
                this.instructionsAfterFieldAccess.add((AbstractInsnNode)new IntInsnNode(opcode, operand));
            }
            super.visitIntInsn(opcode, operand);
        }

        public void visitVarInsn(int opcode, int operand) {
            if (this.fieldAccessNode != null) {
                this.instructionsAfterFieldAccess.add((AbstractInsnNode)new VarInsnNode(opcode, operand));
            }
            super.visitVarInsn(opcode, operand);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
            if (this.fieldAccessNode == null || !METHOD_IDENTIFIER.equals(new MethodIdentifier(name, desc, null))) {
                return;
            }
            this.mv.visitVarInsn(25, 0);
            this.mv.visitFieldInsn(180, EvaluatorMissingCheckVisitor.this.className, EvaluatorMissingCheckVisitor.TYPE_CHECKER_NAME, EvaluatorMissingCheckVisitor.TYPE_CHECKER_DESC);
            this.mv.visitVarInsn(25, 0);
            this.fieldAccessNode.accept(this.mv);
            for (AbstractInsnNode instruction : this.instructionsAfterFieldAccess) {
                instruction.accept(this.mv);
            }
            this.mv.visitVarInsn(25, 2);
            this.mv.visitMethodInsn(182, EvaluatorMissingCheckVisitor.TYPE_CHECKER_CLASS, EvaluatorMissingCheckVisitor.IS_MISSING, EvaluatorMissingCheckVisitor.TYPECHECK_METHOD_DESC, false);
            EvaluatorMissingCheckVisitor.this.lastAddedLabel = new Label();
            this.mv.visitJumpInsn(153, EvaluatorMissingCheckVisitor.this.lastAddedLabel);
            this.mv.visitInsn(177);
            this.mv.visitLabel(EvaluatorMissingCheckVisitor.this.lastAddedLabel);
        }

        public void visitLabel(Label label) {
            if (this.updateToNextLabel) {
                EvaluatorMissingCheckVisitor.this.lastAddedLabel = label;
                this.updateToNextLabel = false;
            }
            super.visitLabel(label);
        }

        public void visitJumpInsn(int opcode, Label label) {
            super.visitJumpInsn(opcode, label);
            if (EvaluatorMissingCheckVisitor.this.lastAddedLabel == null) {
                return;
            }
            try {
                if (label.getOffset() < EvaluatorMissingCheckVisitor.this.lastAddedLabel.getOffset()) {
                    this.updateToNextLabel = true;
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    class ConstructorVisitor
    extends MethodVisitor {
        public ConstructorVisitor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitInsn(int opcode) {
            if (opcode != 177) {
                this.mv.visitInsn(opcode);
                return;
            }
            this.mv.visitVarInsn(25, 0);
            this.mv.visitTypeInsn(187, EvaluatorMissingCheckVisitor.TYPE_CHECKER_CLASS);
            this.mv.visitInsn(89);
            this.mv.visitMethodInsn(183, EvaluatorMissingCheckVisitor.TYPE_CHECKER_CLASS, EvaluatorMissingCheckVisitor.CONSTRUCTOR, "()V", true);
            this.mv.visitFieldInsn(181, EvaluatorMissingCheckVisitor.this.className, EvaluatorMissingCheckVisitor.TYPE_CHECKER_NAME, EvaluatorMissingCheckVisitor.TYPE_CHECKER_DESC);
            this.mv.visitInsn(177);
        }
    }
}

