/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.staticcodegen;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.asterix.runtime.evaluators.staticcodegen.EvaluatorMissingCheckVisitor;
import org.apache.asterix.runtime.evaluators.staticcodegen.EvaluatorNullCheckVisitor;
import org.apache.asterix.runtime.evaluators.staticcodegen.GatherEvaluatorCreationVisitor;
import org.apache.asterix.runtime.evaluators.staticcodegen.GatherEvaluatorFactoryCreationVisitor;
import org.apache.asterix.runtime.evaluators.staticcodegen.GatherInnerClassVisitor;
import org.apache.asterix.runtime.evaluators.staticcodegen.RenameClassVisitor;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class CodeGenUtil {
    public static final String DEFAULT_SUFFIX_FOR_GENERATED_CLASS = "Gen";
    private static final String OBJECT_CLASS_NAME = "java/lang/Object";
    private static final String DESCRIPTOR_SUPER_CLASS_NAME = "org/apache/asterix/runtime/evaluators/base/AbstractScalarFunctionDynamicDescriptor";
    private static final String EVALUATOR_FACTORY = "EvaluatorFactory";
    private static final String EVALUATOR = "Evaluator";
    private static final String INNER = "Inner";
    private static final String DOLLAR = "$";
    private static final String NESTED_CLASSNAME_PREFIX = "_";

    public static List<Pair<String, String>> generateScalarFunctionDescriptorBinary(String packagePrefix, String originalFuncDescriptorClassName, String suffixForGeneratedClass, ClassLoader classLoader, ClassByteCodeAction action) throws IOException, ClassNotFoundException {
        if ((originalFuncDescriptorClassName = CodeGenUtil.toInternalClassName(originalFuncDescriptorClassName)).equals(DESCRIPTOR_SUPER_CLASS_NAME)) {
            return Collections.emptyList();
        }
        String targetFuncDescriptorClassName = CodeGenUtil.getGeneratedFunctionDescriptorInternalClassName(originalFuncDescriptorClassName, suffixForGeneratedClass);
        ArrayList<Pair<String, String>> nameMappings = new ArrayList<Pair<String, String>>();
        Class<?> evaluatorClass = CodeGenUtil.class.getClassLoader().loadClass(CodeGenUtil.toJdkStandardName(originalFuncDescriptorClassName));
        nameMappings.addAll(CodeGenUtil.generateScalarFunctionDescriptorBinary(packagePrefix, evaluatorClass.getSuperclass().getName(), suffixForGeneratedClass, classLoader, action));
        nameMappings.add(Pair.of((Object)originalFuncDescriptorClassName, (Object)targetFuncDescriptorClassName));
        nameMappings.add(Pair.of((Object)CodeGenUtil.toJdkStandardName(originalFuncDescriptorClassName), (Object)CodeGenUtil.toJdkStandardName(targetFuncDescriptorClassName)));
        ClassReader reader = new ClassReader(CodeGenUtil.getResourceStream(originalFuncDescriptorClassName, classLoader));
        GatherEvaluatorFactoryCreationVisitor evalFactoryCreationVisitor = new GatherEvaluatorFactoryCreationVisitor(CodeGenUtil.toInternalClassName(packagePrefix));
        reader.accept((ClassVisitor)evalFactoryCreationVisitor, 0);
        Set<String> evaluatorFactoryClassNames = evalFactoryCreationVisitor.getCreatedEvaluatorFactoryClassNames();
        CodeGenUtil.generateNonEvalInnerClasses(reader, evaluatorFactoryClassNames, nameMappings, suffixForGeneratedClass, classLoader, action);
        int evalFactoryCounter = 0;
        for (String evaluateFactoryClassName : evaluatorFactoryClassNames) {
            CodeGenUtil.generateEvaluatorFactoryClassBinary(packagePrefix, evaluateFactoryClassName, suffixForGeneratedClass, evalFactoryCounter++, nameMappings, classLoader, action);
        }
        ClassWriter writer = new ClassWriter(reader, 0);
        RenameClassVisitor renamingVisitor = new RenameClassVisitor((ClassVisitor)writer, nameMappings);
        reader.accept((ClassVisitor)renamingVisitor, 0);
        action.runAction(targetFuncDescriptorClassName, writer.toByteArray());
        return nameMappings;
    }

    public static String getGeneratedFunctionDescriptorClassName(String originalFuncDescriptorClassName, String suffixForGeneratedClass) {
        return CodeGenUtil.toJdkStandardName(CodeGenUtil.getGeneratedFunctionDescriptorInternalClassName(originalFuncDescriptorClassName, suffixForGeneratedClass));
    }

    private static String getGeneratedFunctionDescriptorInternalClassName(String originalFuncDescriptorClassName, String suffixForGeneratedClass) {
        String originalFuncDescriptorClassInternalName = CodeGenUtil.toInternalClassName(originalFuncDescriptorClassName);
        String targetFuncDescriptorClassName = CodeGenUtil.getGeneratedClassName(originalFuncDescriptorClassInternalName, suffixForGeneratedClass, 0);
        return targetFuncDescriptorClassName;
    }

    static String applyMapping(List<Pair<String, String>> nameMappings, String inputStr) {
        if (inputStr == null) {
            return null;
        }
        String result = inputStr;
        for (int index = nameMappings.size() - 1; index >= 0; --index) {
            Pair<String, String> entry = nameMappings.get(index);
            if (!result.contains((CharSequence)entry.getLeft())) continue;
            return result.replace((CharSequence)entry.getLeft(), (CharSequence)entry.getRight());
        }
        return result;
    }

    private static void generateEvaluatorFactoryClassBinary(String packagePrefix, String originalEvaluatorFactoryClassName, String suffixForGeneratedClass, int factoryCounter, List<Pair<String, String>> nameMappings, ClassLoader classLoader, ClassByteCodeAction action) throws IOException, ClassNotFoundException {
        originalEvaluatorFactoryClassName = CodeGenUtil.toInternalClassName(originalEvaluatorFactoryClassName);
        String targetEvaluatorFactoryClassName = CodeGenUtil.getGeneratedClassName(originalEvaluatorFactoryClassName, EVALUATOR_FACTORY + suffixForGeneratedClass, factoryCounter);
        nameMappings.add((Pair<String, String>)Pair.of((Object)originalEvaluatorFactoryClassName, (Object)targetEvaluatorFactoryClassName));
        nameMappings.add((Pair<String, String>)Pair.of((Object)CodeGenUtil.toJdkStandardName(originalEvaluatorFactoryClassName), (Object)CodeGenUtil.toJdkStandardName(targetEvaluatorFactoryClassName)));
        ClassReader reader = new ClassReader(CodeGenUtil.getResourceStream(originalEvaluatorFactoryClassName, classLoader));
        GatherEvaluatorCreationVisitor evalCreationVisitor = new GatherEvaluatorCreationVisitor(CodeGenUtil.toInternalClassName(packagePrefix));
        reader.accept((ClassVisitor)evalCreationVisitor, 0);
        Set<String> evaluatorClassNames = evalCreationVisitor.getCreatedEvaluatorClassNames();
        CodeGenUtil.generateNonEvalInnerClasses(reader, evaluatorClassNames, nameMappings, suffixForGeneratedClass, classLoader, action);
        int evalCounter = 0;
        for (String evaluateClassName : evaluatorClassNames) {
            CodeGenUtil.generateEvaluatorClassBinary(evaluateClassName, suffixForGeneratedClass, evalCounter++, nameMappings, classLoader, action);
        }
        ClassWriter writer = new ClassWriter(reader, 0);
        RenameClassVisitor renamingVisitor = new RenameClassVisitor((ClassVisitor)writer, nameMappings);
        reader.accept((ClassVisitor)renamingVisitor, 0);
        action.runAction(targetEvaluatorFactoryClassName, writer.toByteArray());
    }

    private static void generateEvaluatorClassBinary(String originalEvaluatorClassName, String suffixForGeneratedClass, int evalCounter, List<Pair<String, String>> nameMappings, ClassLoader classLoader, ClassByteCodeAction action) throws IOException, ClassNotFoundException {
        if ((originalEvaluatorClassName = CodeGenUtil.toInternalClassName(originalEvaluatorClassName)).equals(OBJECT_CLASS_NAME)) {
            return;
        }
        String targetEvaluatorClassName = CodeGenUtil.getGeneratedClassName(originalEvaluatorClassName, EVALUATOR + suffixForGeneratedClass, evalCounter);
        Class<?> evaluatorClass = CodeGenUtil.class.getClassLoader().loadClass(CodeGenUtil.toJdkStandardName(originalEvaluatorClassName));
        CodeGenUtil.generateEvaluatorClassBinary(evaluatorClass.getSuperclass().getName(), suffixForGeneratedClass, evalCounter, nameMappings, classLoader, action);
        nameMappings.add((Pair<String, String>)Pair.of((Object)originalEvaluatorClassName, (Object)targetEvaluatorClassName));
        nameMappings.add((Pair<String, String>)Pair.of((Object)CodeGenUtil.toJdkStandardName(originalEvaluatorClassName), (Object)CodeGenUtil.toJdkStandardName(targetEvaluatorClassName)));
        ClassReader firstPassReader = new ClassReader(CodeGenUtil.getResourceStream(originalEvaluatorClassName, classLoader));
        HashSet<String> excludedNames = new HashSet<String>();
        for (Pair<String, String> entry : nameMappings) {
            excludedNames.add((String)entry.getKey());
        }
        CodeGenUtil.generateNonEvalInnerClasses(firstPassReader, excludedNames, nameMappings, suffixForGeneratedClass, classLoader, action);
        ClassWriter firstPassWriter = new ClassWriter(firstPassReader, 0);
        EvaluatorMissingCheckVisitor missingHandlingVisitor = new EvaluatorMissingCheckVisitor((ClassVisitor)firstPassWriter);
        firstPassReader.accept((ClassVisitor)missingHandlingVisitor, 0);
        ClassReader secondPassReader = new ClassReader(firstPassWriter.toByteArray());
        ClassWriter secondPassWriter = new ClassWriter(secondPassReader, 3);
        RenameClassVisitor renamingVisitor = new RenameClassVisitor((ClassVisitor)secondPassWriter, nameMappings);
        EvaluatorNullCheckVisitor nullHandlingVisitor = new EvaluatorNullCheckVisitor(renamingVisitor, missingHandlingVisitor.getLastAddedLabel());
        secondPassReader.accept((ClassVisitor)nullHandlingVisitor, 0);
        action.runAction(targetEvaluatorClassName, secondPassWriter.toByteArray());
    }

    private static void generateNonEvalInnerClasses(ClassReader reader, Set<String> evalClassNames, List<Pair<String, String>> nameMappings, String suffixForGeneratedClass, ClassLoader classLoader, ClassByteCodeAction action) throws IOException {
        GatherInnerClassVisitor innerClassVisitor = new GatherInnerClassVisitor();
        reader.accept((ClassVisitor)innerClassVisitor, 0);
        Set<String> innerClassNames = innerClassVisitor.getInnerClassNames();
        innerClassNames.removeAll(evalClassNames);
        int counter = 0;
        String suffix = INNER + suffixForGeneratedClass;
        for (String innerClassName : innerClassNames) {
            String targetInnerClassName = CodeGenUtil.getGeneratedClassName(innerClassName, suffix, counter++);
            nameMappings.add((Pair<String, String>)Pair.of((Object)innerClassName, (Object)targetInnerClassName));
            nameMappings.add((Pair<String, String>)Pair.of((Object)CodeGenUtil.toJdkStandardName(innerClassName), (Object)CodeGenUtil.toJdkStandardName(targetInnerClassName)));
            ClassReader innerClassReader = new ClassReader(CodeGenUtil.getResourceStream(innerClassName, classLoader));
            ClassWriter writer = new ClassWriter(innerClassReader, 0);
            RenameClassVisitor renamingVisitor = new RenameClassVisitor((ClassVisitor)writer, nameMappings);
            innerClassReader.accept((ClassVisitor)renamingVisitor, 0);
            action.runAction(targetInnerClassName, writer.toByteArray());
        }
    }

    private static String toInternalClassName(String name) {
        return name.replace(".", "/");
    }

    private static String toJdkStandardName(String name) {
        return name.replace("/", ".");
    }

    private static String getGeneratedClassName(String originalClassName, String suffix, int counter) {
        StringBuilder sb = new StringBuilder();
        int end = originalClassName.indexOf(DOLLAR);
        if (end < 0) {
            end = originalClassName.length();
        }
        String name = originalClassName.substring(0, end);
        sb.append(name);
        sb.append(DOLLAR);
        sb.append(NESTED_CLASSNAME_PREFIX);
        sb.append(suffix);
        if (counter > 0) {
            sb.append(counter);
        }
        return sb.toString();
    }

    private static InputStream getResourceStream(String className, ClassLoader classLoader) {
        return classLoader.getResourceAsStream(className.replace('.', '/') + ".class");
    }

    public static interface ClassByteCodeAction {
        public void runAction(String var1, byte[] var2) throws IOException;
    }
}

