/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.dataflow.data.nontagged.serde.ARecordSerializerDeserializer;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class FieldAccessByNameEvalFactory
implements IScalarEvaluatorFactory {
    private static final long serialVersionUID = 1L;
    private IScalarEvaluatorFactory recordEvalFactory;
    private IScalarEvaluatorFactory fldNameEvalFactory;

    public FieldAccessByNameEvalFactory(IScalarEvaluatorFactory recordEvalFactory, IScalarEvaluatorFactory fldNameEvalFactory) {
        this.recordEvalFactory = recordEvalFactory;
        this.fldNameEvalFactory = fldNameEvalFactory;
    }

    public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
        return new IScalarEvaluator(){
            private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
            private DataOutput out = this.resultStorage.getDataOutput();
            private IPointable inputArg0 = new VoidPointable();
            private IPointable inputArg1 = new VoidPointable();
            private IScalarEvaluator eval0 = FieldAccessByNameEvalFactory.access$000(FieldAccessByNameEvalFactory.this).createScalarEvaluator(ctx);
            private IScalarEvaluator eval1 = FieldAccessByNameEvalFactory.access$100(FieldAccessByNameEvalFactory.this).createScalarEvaluator(ctx);
            private int fieldValueOffset;
            private int fieldValueLength;
            private ATypeTag fieldValueTypeTag;

            public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                try {
                    this.resultStorage.reset();
                    this.eval0.evaluate(tuple, this.inputArg0);
                    this.eval1.evaluate(tuple, this.inputArg1);
                    byte[] serRecord = this.inputArg0.getByteArray();
                    int serRecordOffset = this.inputArg0.getStartOffset();
                    int serRecordLen = this.inputArg0.getLength();
                    if (serRecord[serRecordOffset] != ATypeTag.SERIALIZED_RECORD_TYPE_TAG) {
                        throw new TypeMismatchException(BuiltinFunctions.FIELD_ACCESS_BY_NAME, (Integer)0, serRecord[serRecordOffset], ATypeTag.SERIALIZED_RECORD_TYPE_TAG);
                    }
                    byte[] serFldName = this.inputArg1.getByteArray();
                    int serFldNameOffset = this.inputArg1.getStartOffset();
                    this.fieldValueOffset = ARecordSerializerDeserializer.getFieldOffsetByName((byte[])serRecord, (int)serRecordOffset, (int)serRecordLen, (byte[])serFldName, (int)serFldNameOffset);
                    if (this.fieldValueOffset < 0) {
                        this.out.writeByte(ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
                        result.set((IValueReference)this.resultStorage);
                        return;
                    }
                    this.fieldValueTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(serRecord[this.fieldValueOffset]);
                    this.fieldValueLength = NonTaggedFormatUtil.getFieldValueLength((byte[])serRecord, (int)this.fieldValueOffset, (ATypeTag)this.fieldValueTypeTag, (boolean)true) + 1;
                    result.set(serRecord, this.fieldValueOffset, this.fieldValueLength);
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
                catch (AsterixException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
        };
    }

    static /* synthetic */ IScalarEvaluatorFactory access$000(FieldAccessByNameEvalFactory x0) {
        return x0.recordEvalFactory;
    }

    static /* synthetic */ IScalarEvaluatorFactory access$100(FieldAccessByNameEvalFactory x0) {
        return x0.fldNameEvalFactory;
    }
}

