/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.binary;

import java.io.IOException;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.functions.binary.AbstractBinaryScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.ByteArrayPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.encoding.VarLenIntEncoderDecoder;

public abstract class AbstractSubBinaryEvaluator
extends AbstractBinaryScalarEvaluator {
    private ByteArrayPointable byteArrayPointable = new ByteArrayPointable();
    private byte[] metaBuffer = new byte[5];
    protected final String functionName;
    private static final ATypeTag[] EXPECTED_INPUT_TAGS = new ATypeTag[]{ATypeTag.BINARY, ATypeTag.INT32};

    public AbstractSubBinaryEvaluator(IHyracksTaskContext context, IScalarEvaluatorFactory[] copyEvaluatorFactories, String functionName) throws HyracksDataException {
        super(context, copyEvaluatorFactories);
        this.functionName = functionName;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        for (int i = 0; i < this.pointables.length; ++i) {
            this.evaluators[i].evaluate(tuple, this.pointables[i]);
        }
        try {
            ATypeTag argTag0 = ATypeTag.VALUE_TYPE_MAPPING[this.pointables[0].getByteArray()[this.pointables[0].getStartOffset()]];
            ATypeTag argTag1 = ATypeTag.VALUE_TYPE_MAPPING[this.pointables[1].getByteArray()[this.pointables[1].getStartOffset()]];
            this.checkTypeMachingThrowsIfNot(this.functionName, EXPECTED_INPUT_TAGS, argTag0, argTag1);
            this.byteArrayPointable.set(this.pointables[0].getByteArray(), this.pointables[0].getStartOffset() + 1, this.pointables[0].getLength() - 1);
            byte[] startBytes = this.pointables[1].getByteArray();
            int offset = this.pointables[1].getStartOffset();
            int subStart = ATypeHierarchy.getIntegerValue((String)BuiltinFunctions.SUBBINARY_FROM.getName(), (int)1, (byte[])startBytes, (int)offset) - 1;
            int totalLength = this.byteArrayPointable.getContentLength();
            int subLength = this.getSubLength(tuple);
            if (subStart < 0) {
                subStart = 0;
            }
            if (subStart >= totalLength || subLength < 0) {
                subLength = 0;
            } else if (subLength > totalLength || subStart + subLength > totalLength) {
                subLength = totalLength - subStart;
            }
            this.dataOutput.write(ATypeTag.BINARY.serialize());
            int metaLength = VarLenIntEncoderDecoder.encode((int)subLength, (byte[])this.metaBuffer, (int)0);
            this.dataOutput.write(this.metaBuffer, 0, metaLength);
            this.dataOutput.write(this.byteArrayPointable.getByteArray(), this.byteArrayPointable.getContentStartOffset() + subStart, subLength);
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
        result.set((IValueReference)this.resultStorage);
    }

    protected abstract int getSubLength(IFrameTupleReference var1) throws HyracksDataException;
}

