/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.string.UTF8StringUtil;

public class ADoubleConstructorDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new ADoubleConstructorDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private final DataOutput out = this.resultStorage.getDataOutput();
                    private final IPointable inputArg = new VoidPointable();
                    private IScalarEvaluator eval;
                    private final byte[] POSITIVE_INF;
                    private final byte[] NEGATIVE_INF;
                    private final byte[] NAN;
                    IBinaryComparator utf8BinaryComparator;
                    private AMutableDouble aDouble;
                    private ISerializerDeserializer<ADouble> doubleSerde;
                    private final UTF8StringPointable utf8Ptr;
                    {
                        this.eval = args[0].createScalarEvaluator(ctx);
                        this.POSITIVE_INF = UTF8StringUtil.writeStringToBytes((String)"INF");
                        this.NEGATIVE_INF = UTF8StringUtil.writeStringToBytes((String)"-INF");
                        this.NAN = UTF8StringUtil.writeStringToBytes((String)"NaN");
                        this.utf8BinaryComparator = BinaryComparatorFactoryProvider.UTF8STRING_POINTABLE_INSTANCE.createBinaryComparator();
                        this.aDouble = new AMutableDouble(0.0);
                        this.doubleSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
                        this.utf8Ptr = new UTF8StringPointable();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        try {
                            this.resultStorage.reset();
                            this.eval.evaluate(tuple, this.inputArg);
                            byte[] serString = this.inputArg.getByteArray();
                            int offset = this.inputArg.getStartOffset();
                            int len = this.inputArg.getLength();
                            if (serString[offset] == ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                                if (this.utf8BinaryComparator.compare(serString, offset + 1, len - 1, this.POSITIVE_INF, 0, 5) == 0) {
                                    this.aDouble.setValue(Double.POSITIVE_INFINITY);
                                } else if (this.utf8BinaryComparator.compare(serString, offset + 1, len - 1, this.NEGATIVE_INF, 0, 6) == 0) {
                                    this.aDouble.setValue(Double.NEGATIVE_INFINITY);
                                } else if (this.utf8BinaryComparator.compare(serString, offset + 1, len - 1, this.NAN, 0, 5) == 0) {
                                    this.aDouble.setValue(Double.NaN);
                                } else {
                                    this.utf8Ptr.set(serString, offset + 1, len - 1);
                                    this.aDouble.setValue(Double.parseDouble(this.utf8Ptr.toString()));
                                }
                            } else {
                                throw new TypeMismatchException(ADoubleConstructorDescriptor.this.getIdentifier(), (Integer)0, serString[offset], ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                            }
                            this.doubleSerde.serialize((Object)this.aDouble, this.out);
                            result.set((IValueReference)this.resultStorage);
                        }
                        catch (IOException e) {
                            throw new InvalidDataFormatException(ADoubleConstructorDescriptor.this.getIdentifier(), e, ATypeTag.SERIALIZED_DATETIME_TYPE_TAG);
                        }
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.DOUBLE_CONSTRUCTOR;
    }
}

