/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.common;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.asterix.dataflow.data.nontagged.comparators.ListItemBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.hash.ListItemBinaryHashFunctionFactory;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AFloat;
import org.apache.asterix.om.base.AMutableFloat;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.evaluators.common.AbstractAsterixListIterator;
import org.apache.asterix.runtime.evaluators.common.OrderedListIterator;
import org.apache.asterix.runtime.evaluators.common.UnorderedListIterator;
import org.apache.asterix.runtime.evaluators.functions.BinaryHashMap;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.data.std.util.BinaryEntry;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class SimilarityJaccardEvaluator
implements IScalarEvaluator {
    protected static final int MIN_TABLE_SIZE = 100;
    protected static final int TABLE_FRAME_SIZE = 32768;
    protected static final int TYPE_INDICATOR_SIZE = 1;
    protected final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    protected final DataOutput out = this.resultStorage.getDataOutput();
    protected final IPointable argPtr1 = new VoidPointable();
    protected final IPointable argPtr2 = new VoidPointable();
    protected final IScalarEvaluator firstOrdListEval;
    protected final IScalarEvaluator secondOrdListEval;
    protected final OrderedListIterator fstOrdListIter = new OrderedListIterator();
    protected final OrderedListIterator sndOrdListIter = new OrderedListIterator();
    protected final UnorderedListIterator fstUnordListIter = new UnorderedListIterator();
    protected final UnorderedListIterator sndUnordListIter = new UnorderedListIterator();
    protected AbstractAsterixListIterator firstListIter;
    protected AbstractAsterixListIterator secondListIter;
    protected final AMutableFloat aFloat = new AMutableFloat(0.0f);
    protected final ISerializerDeserializer<AFloat> floatSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AFLOAT);
    protected ATypeTag firstTypeTag;
    protected ATypeTag secondTypeTag;
    protected float jaccSim = 0.0f;
    protected ATypeTag firstItemTypeTag;
    protected ATypeTag secondItemTypeTag;
    protected BinaryHashMap hashMap;
    protected BinaryEntry keyEntry = new BinaryEntry();
    protected BinaryEntry valEntry = new BinaryEntry();
    protected final boolean ignoreCase = true;
    protected int hashTableSize = 100;

    public SimilarityJaccardEvaluator(IScalarEvaluatorFactory[] args, IHyracksTaskContext context) throws HyracksDataException {
        this.firstOrdListEval = args[0].createScalarEvaluator(context);
        this.secondOrdListEval = args[1].createScalarEvaluator(context);
        byte[] emptyValBuf = new byte[8];
        Arrays.fill(emptyValBuf, (byte)0);
        this.valEntry.set(emptyValBuf, 0, 8);
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        this.firstOrdListEval.evaluate(tuple, this.argPtr1);
        this.secondOrdListEval.evaluate(tuple, this.argPtr2);
        this.firstTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.argPtr1.getByteArray()[this.argPtr1.getStartOffset()]);
        this.secondTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.argPtr2.getByteArray()[this.argPtr2.getStartOffset()]);
        this.firstItemTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.argPtr1.getByteArray()[this.argPtr1.getStartOffset() + 1]);
        this.secondItemTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.argPtr2.getByteArray()[this.argPtr2.getStartOffset() + 1]);
        if (!this.checkArgTypes(this.firstTypeTag, this.secondTypeTag)) {
            result.set((IValueReference)this.resultStorage);
            return;
        }
        this.jaccSim = this.prepareLists(this.argPtr1, this.argPtr2) ? this.computeResult() : 0.0f;
        try {
            this.writeResult(this.jaccSim);
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
        result.set((IValueReference)this.resultStorage);
    }

    protected boolean prepareLists(IPointable left, IPointable right) throws HyracksDataException {
        this.firstListIter.reset(left.getByteArray(), left.getStartOffset());
        this.secondListIter.reset(right.getByteArray(), right.getStartOffset());
        if (this.firstListIter.size() == 0 || this.secondListIter.size() == 0) {
            return false;
        }
        this.hashTableSize = Math.max(Math.max(this.firstListIter.size(), this.secondListIter.size()), 100);
        return true;
    }

    protected float computeResult() throws HyracksDataException {
        int firstListSize = this.firstListIter.size();
        int secondListSize = this.secondListIter.size();
        int unionSize = firstListSize + secondListSize;
        AbstractAsterixListIterator buildList = firstListSize < secondListSize ? this.firstListIter : this.secondListIter;
        AbstractAsterixListIterator probeList = buildList == this.firstListIter ? this.secondListIter : this.firstListIter;
        int buildListSize = buildList == this.firstListIter ? firstListSize : secondListSize;
        int probeListSize = probeList == this.firstListIter ? firstListSize : secondListSize;
        ATypeTag buildItemTypeTag = buildList == this.firstListIter ? this.firstItemTypeTag : this.secondItemTypeTag;
        ATypeTag probeItemTypeTag = probeList == this.firstListIter ? this.firstItemTypeTag : this.secondItemTypeTag;
        this.setHashMap(buildItemTypeTag, probeItemTypeTag);
        this.buildHashMap(buildList);
        int intersectionSize = this.probeHashMap(probeList, buildListSize, probeListSize);
        if (intersectionSize < 0) {
            return -1.0f;
        }
        return (float)intersectionSize / (float)(unionSize -= intersectionSize);
    }

    protected void buildHashMap(AbstractAsterixListIterator buildIter) throws HyracksDataException {
        IntegerPointable.setInteger((byte[])this.valEntry.getBuf(), (int)0, (int)1);
        while (buildIter.hasNext()) {
            byte[] buf = buildIter.getData();
            int off = buildIter.getPos();
            int len = buildIter.getItemLen();
            this.keyEntry.set(buf, off, len);
            BinaryEntry entry = this.hashMap.put(this.keyEntry, this.valEntry);
            if (entry != null) {
                int firstValInt = IntegerPointable.getInteger((byte[])entry.getBuf(), (int)entry.getOffset());
                IntegerPointable.setInteger((byte[])entry.getBuf(), (int)entry.getOffset(), (int)(firstValInt + 1));
            }
            buildIter.next();
        }
    }

    protected int probeHashMap(AbstractAsterixListIterator probeIter, int buildListSize, int probeListSize) throws HyracksDataException {
        int intersectionSize = 0;
        while (probeIter.hasNext()) {
            byte[] buf = probeIter.getData();
            int off = probeIter.getPos();
            int len = probeIter.getItemLen();
            this.keyEntry.set(buf, off, len);
            BinaryEntry entry = this.hashMap.get(this.keyEntry);
            if (entry != null) {
                int firstValInt = IntegerPointable.getInteger((byte[])entry.getBuf(), (int)entry.getOffset());
                if (firstValInt == 0) continue;
                int secondValInt = IntegerPointable.getInteger((byte[])entry.getBuf(), (int)(entry.getOffset() + 4));
                intersectionSize -= firstValInt < secondValInt ? firstValInt : secondValInt;
                intersectionSize += firstValInt < ++secondValInt ? firstValInt : secondValInt;
                IntegerPointable.setInteger((byte[])entry.getBuf(), (int)(entry.getOffset() + 4), (int)secondValInt);
            }
            probeIter.next();
        }
        return intersectionSize;
    }

    protected void setHashMap(ATypeTag buildItemTypeTag, ATypeTag probeItemTypeTag) {
        if (this.hashMap != null) {
            this.hashMap.clear();
            return;
        }
        IBinaryHashFunction putHashFunc = ListItemBinaryHashFunctionFactory.INSTANCE.createBinaryHashFunction(buildItemTypeTag, true);
        IBinaryHashFunction getHashFunc = ListItemBinaryHashFunctionFactory.INSTANCE.createBinaryHashFunction(probeItemTypeTag, true);
        IBinaryComparator cmp = ListItemBinaryComparatorFactory.INSTANCE.createBinaryComparator(buildItemTypeTag, probeItemTypeTag, true);
        this.hashMap = new BinaryHashMap(this.hashTableSize, 32768, putHashFunc, getHashFunc, cmp);
    }

    protected boolean checkArgTypes(ATypeTag typeTag1, ATypeTag typeTag2) throws HyracksDataException {
        switch (typeTag1) {
            case ORDEREDLIST: {
                this.firstListIter = this.fstOrdListIter;
                break;
            }
            case UNORDEREDLIST: {
                this.firstListIter = this.fstUnordListIter;
                break;
            }
            default: {
                throw new TypeMismatchException(BuiltinFunctions.SIMILARITY_JACCARD, (Integer)0, typeTag1.serialize(), ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG, ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG);
            }
        }
        switch (typeTag2) {
            case ORDEREDLIST: {
                this.secondListIter = this.sndOrdListIter;
                break;
            }
            case UNORDEREDLIST: {
                this.secondListIter = this.sndUnordListIter;
                break;
            }
            default: {
                throw new TypeMismatchException(BuiltinFunctions.SIMILARITY_JACCARD, (Integer)1, typeTag2.serialize(), ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG, ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG);
            }
        }
        return true;
    }

    protected void writeResult(float jacc) throws IOException {
        this.aFloat.setValue(jacc);
        this.floatSerde.serialize((Object)this.aFloat, this.out);
    }
}

