/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.functions.IFunctionManager;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;

public class FunctionManagerImpl
implements IFunctionManager {
    private final Map<Pair<FunctionIdentifier, Integer>, IFunctionDescriptorFactory> functions = new HashMap<Pair<FunctionIdentifier, Integer>, IFunctionDescriptorFactory>();

    public synchronized IFunctionDescriptor lookupFunction(FunctionIdentifier fid) throws AlgebricksException {
        Pair key = new Pair((Object)fid, (Object)fid.getArity());
        IFunctionDescriptorFactory factory = this.functions.get(key);
        if (factory == null) {
            throw new AlgebricksException("Inappropriate use of function '" + fid.getName() + "'");
        }
        return factory.createFunctionDescriptor();
    }

    public synchronized void registerFunction(IFunctionDescriptorFactory descriptorFactory) throws AlgebricksException {
        FunctionIdentifier fid = descriptorFactory.createFunctionDescriptor().getIdentifier();
        this.functions.put((Pair<FunctionIdentifier, Integer>)new Pair((Object)fid, (Object)fid.getArity()), descriptorFactory);
    }

    public synchronized void unregisterFunction(IFunctionDescriptorFactory descriptorFactory) throws AlgebricksException {
        FunctionIdentifier fid = descriptorFactory.createFunctionDescriptor().getIdentifier();
        Pair key = new Pair((Object)fid, (Object)fid.getArity());
        this.functions.remove(key);
    }

    public synchronized Iterator<IFunctionDescriptorFactory> iterator() {
        return new ArrayList<IFunctionDescriptorFactory>(this.functions.values()).iterator();
    }
}

