/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.common;

import java.io.IOException;
import java.io.Serializable;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.common.EditDistanceEvaluator;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.data.std.util.ISequenceIterator;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class EditDistanceCheckEvaluator
extends EditDistanceEvaluator {
    protected final IScalarEvaluator edThreshEval;
    protected int edThresh;
    private final IPointable argPtrThreshold = new VoidPointable();
    protected final OrderedListBuilder listBuilder;
    protected ArrayBackedValueStorage listItemVal;
    protected final ISerializerDeserializer<ABoolean> booleanSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN);

    public EditDistanceCheckEvaluator(IScalarEvaluatorFactory[] args, IHyracksTaskContext context) throws HyracksDataException {
        super(args, context);
        this.edThreshEval = args[2].createScalarEvaluator(context);
        this.listBuilder = new OrderedListBuilder();
        this.listItemVal = new ArrayBackedValueStorage();
    }

    @Override
    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        this.firstStringEval.evaluate(tuple, this.argPtr1);
        this.firstTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.argPtr1.getByteArray()[this.argPtr1.getStartOffset()]);
        this.secondStringEval.evaluate(tuple, this.argPtr2);
        this.secondTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.argPtr2.getByteArray()[this.argPtr2.getStartOffset()]);
        this.edThreshEval.evaluate(tuple, this.argPtrThreshold);
        if (!this.checkArgTypes(this.firstTypeTag, this.secondTypeTag)) {
            result.set((IValueReference)this.resultStorage);
            return;
        }
        try {
            this.edThresh = ATypeHierarchy.getIntegerValue((String)BuiltinFunctions.EDIT_DISTANCE_CHECK.getName(), (int)2, (byte[])this.argPtrThreshold.getByteArray(), (int)this.argPtrThreshold.getStartOffset());
            if (this.edThresh < 0) {
                throw new RuntimeDataException(10, new Serializable[]{BuiltinFunctions.EDIT_DISTANCE_CHECK.getName(), Integer.valueOf(3), Integer.valueOf(this.edThresh)});
            }
            this.editDistance = this.computeResult(this.argPtr1, this.argPtr2, this.firstTypeTag);
            this.writeResult(this.editDistance);
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
        result.set((IValueReference)this.resultStorage);
    }

    @Override
    protected int computeResult(IPointable left, IPointable right, ATypeTag argType) throws HyracksDataException {
        byte[] leftBytes = left.getByteArray();
        int leftStartOffset = left.getStartOffset();
        byte[] rightBytes = right.getByteArray();
        int rightStartOffset = right.getStartOffset();
        switch (argType) {
            case STRING: {
                return this.ed.UTF8StringEditDistance(leftBytes, leftStartOffset + 1, rightBytes, rightStartOffset + 1, this.edThresh);
            }
            case ORDEREDLIST: {
                this.firstOrdListIter.reset(leftBytes, leftStartOffset);
                this.secondOrdListIter.reset(rightBytes, rightStartOffset);
                return (int)this.ed.computeSimilarity((ISequenceIterator)this.firstOrdListIter, (ISequenceIterator)this.secondOrdListIter, (float)this.edThresh);
            }
        }
        throw new TypeMismatchException(BuiltinFunctions.EDIT_DISTANCE_CHECK, (Integer)0, argType.serialize(), ATypeTag.SERIALIZED_STRING_TYPE_TAG, ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG);
    }

    @Override
    protected void writeResult(int ed) throws IOException {
        this.listBuilder.reset((AbstractCollectionType)new AOrderedListType((IAType)BuiltinType.ANY, "list"));
        boolean matches = ed >= 0;
        this.listItemVal.reset();
        this.booleanSerde.serialize((Object)(matches ? ABoolean.TRUE : ABoolean.FALSE), this.listItemVal.getDataOutput());
        this.listBuilder.addItem((IValueReference)this.listItemVal);
        this.listItemVal.reset();
        this.aInt64.setValue(matches ? (long)ed : Integer.MAX_VALUE);
        this.int64Serde.serialize((Object)this.aInt64, this.listItemVal.getDataOutput());
        this.listBuilder.addItem((IValueReference)this.listItemVal);
        this.listBuilder.write(this.out, true);
    }
}

