/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.om.functions.BuiltinFunctions;

public class CommonFunctionMapUtil {
    private static final Map<String, String> FUNCTION_NAME_MAP = new HashMap<String, String>();

    private CommonFunctionMapUtil() {
    }

    public static FunctionSignature normalizeBuiltinFunctionSignature(FunctionSignature fs) throws CompilationException {
        String name = fs.getName();
        String lowerCaseName = name.toLowerCase();
        String mappedName = FUNCTION_NAME_MAP.get(lowerCaseName);
        if (mappedName != null) {
            return new FunctionSignature(fs.getNamespace(), mappedName, fs.getArity());
        }
        String understoreName = lowerCaseName.replace('_', '-');
        FunctionSignature newFs = new FunctionSignature(fs.getNamespace(), understoreName, fs.getArity());
        return BuiltinFunctions.isBuiltinCompilerFunction((FunctionSignature)newFs, (boolean)true) ? newFs : fs;
    }

    static {
        FUNCTION_NAME_MAP.put("ceil", "ceiling");
        FUNCTION_NAME_MAP.put("length", "string-length");
        FUNCTION_NAME_MAP.put("lower", "lowercase");
        FUNCTION_NAME_MAP.put("substr", "substring");
        FUNCTION_NAME_MAP.put("upper", "uppercase");
        FUNCTION_NAME_MAP.put("title", "initcap");
        FUNCTION_NAME_MAP.put("regexp_contains", "matches");
        FUNCTION_NAME_MAP.put("regexp_replace", "replace");
        FUNCTION_NAME_MAP.put("power", "caret");
        FUNCTION_NAME_MAP.put("int", "integer");
        FUNCTION_NAME_MAP.put("tinyint", "int8");
        FUNCTION_NAME_MAP.put("smallint", "int16");
        FUNCTION_NAME_MAP.put("integer", "int32");
        FUNCTION_NAME_MAP.put("bigint", "int64");
        FUNCTION_NAME_MAP.put("isnull", "is-null");
        FUNCTION_NAME_MAP.put("ismissing", "is-missing");
        FUNCTION_NAME_MAP.put("isunknown", "is-unknown");
        FUNCTION_NAME_MAP.put("isboolean", "is-boolean");
        FUNCTION_NAME_MAP.put("isbool", "is-boolean");
        FUNCTION_NAME_MAP.put("isnumber", "is-number");
        FUNCTION_NAME_MAP.put("isnum", "is-number");
        FUNCTION_NAME_MAP.put("isstring", "is-string");
        FUNCTION_NAME_MAP.put("isstr", "is-string");
        FUNCTION_NAME_MAP.put("isarray", "is-array");
        FUNCTION_NAME_MAP.put("isobject", "is-object");
        FUNCTION_NAME_MAP.put("isobj", "is-object");
        FUNCTION_NAME_MAP.put("record-merge", "object-merge");
        FUNCTION_NAME_MAP.put("record-get-fields", "object-get-fields");
        FUNCTION_NAME_MAP.put("record-get-field-value", "object-get-field-value");
        FUNCTION_NAME_MAP.put("record-add-fields", "object-add-fields");
        FUNCTION_NAME_MAP.put("record-remove-fields", "object-remove-fields");
    }
}

