/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.rewrites;

import java.util.HashMap;
import org.apache.asterix.lang.common.struct.VarIdentifier;

public final class LangRewritingContext {
    private int mark = 0;
    private int varCounter;
    private int systemVarCounter = 1;
    private HashMap<Integer, VarIdentifier> oldVarIdToNewVarId = new HashMap();

    public LangRewritingContext(int varCounter) {
        this.varCounter = varCounter;
    }

    public int getVarCounter() {
        return this.varCounter;
    }

    public void setVarCounter(int varCounter) {
        this.varCounter = varCounter;
    }

    public VarIdentifier mapOldId(Integer oldId, String varValue) {
        int n = this.newId();
        VarIdentifier newVar = new VarIdentifier(varValue);
        newVar.setId(n);
        this.oldVarIdToNewVarId.put(oldId, newVar);
        return newVar;
    }

    public VarIdentifier getRewrittenVar(Integer oldId) {
        return this.oldVarIdToNewVarId.get(oldId);
    }

    public VarIdentifier newVariable() {
        int id = this.newId();
        return new VarIdentifier("#" + this.systemVarCounter++, id);
    }

    public void markCounter() {
        this.mark = this.varCounter;
    }

    public void resetCounter() {
        this.varCounter = this.mark;
    }

    private int newId() {
        ++this.varCounter;
        return this.varCounter;
    }
}

