/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.client.dataset;

import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.context.IHyracksCommonContext;
import org.apache.hyracks.api.dataset.IHyracksDataset;
import org.apache.hyracks.api.dataset.IHyracksDatasetDirectoryServiceConnection;
import org.apache.hyracks.api.dataset.IHyracksDatasetReader;
import org.apache.hyracks.api.dataset.ResultSetId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.client.dataset.HyracksDatasetDirectoryServiceConnection;
import org.apache.hyracks.client.dataset.HyracksDatasetReader;
import org.apache.hyracks.client.net.ClientNetworkManager;
import org.apache.hyracks.control.nc.resources.memory.FrameManager;

public class HyracksDataset
implements IHyracksDataset {
    private final IHyracksDatasetDirectoryServiceConnection datasetDirectoryServiceConnection;
    private final ClientNetworkManager netManager;
    private final IHyracksCommonContext datasetClientCtx;

    public HyracksDataset(IHyracksClientConnection hcc, int frameSize, int nReaders) throws Exception {
        NetworkAddress ddsAddress = hcc.getDatasetDirectoryServiceInfo();
        this.datasetDirectoryServiceConnection = new HyracksDatasetDirectoryServiceConnection(ddsAddress.getAddress(), ddsAddress.getPort());
        this.netManager = new ClientNetworkManager(nReaders);
        this.netManager.start();
        this.datasetClientCtx = new DatasetClientContext(frameSize);
    }

    public IHyracksDatasetReader createReader(JobId jobId, ResultSetId resultSetId) throws HyracksDataException {
        HyracksDatasetReader reader = null;
        try {
            reader = new HyracksDatasetReader(this.datasetDirectoryServiceConnection, this.netManager, this.datasetClientCtx, jobId, resultSetId);
        }
        catch (Exception e) {
            throw new HyracksDataException((Throwable)e);
        }
        return reader;
    }

    static class DatasetClientContext
    extends FrameManager
    implements IHyracksCommonContext {
        DatasetClientContext(int frameSize) {
            super(frameSize);
        }

        public IIOManager getIOManager() {
            return null;
        }
    }
}

