/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types.hierachy;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;
import org.apache.hyracks.dataflow.common.data.marshalling.DoubleSerializerDeserializer;

public class IntegerToDoubleTypeConvertComputer
implements ITypeConvertComputer {
    public static final IntegerToDoubleTypeConvertComputer INSTANCE = new IntegerToDoubleTypeConvertComputer();

    private IntegerToDoubleTypeConvertComputer() {
    }

    @Override
    public void convertType(byte[] data, int start, int length, DataOutput out) throws IOException {
        long val = 0L;
        switch (length) {
            case 1: {
                val = data[start] & 0xFF;
                break;
            }
            case 2: {
                val = (short)(data[start] << 8 | data[start + 1] & 0xFF);
                break;
            }
            case 4: {
                val = (data[start] & 0xFF) << 24 | (data[start + 1] & 0xFF) << 16 | (data[start + 2] & 0xFF) << 8 | data[start + 3] & 0xFF;
                break;
            }
            case 8: {
                val = (long)(data[start] & 0xFF) << 56 | (long)(data[start + 1] & 0xFF) << 48 | (long)(data[start + 2] & 0xFF) << 40 | (long)(data[start + 3] & 0xFF) << 32 | (long)(data[start + 4] & 0xFF) << 24 | (long)(data[start + 5] & 0xFF) << 16 | (long)(data[start + 6] & 0xFF) << 8 | (long)(data[start + 7] & 0xFF);
                break;
            }
        }
        out.writeByte(ATypeTag.DOUBLE.serialize());
        DoubleSerializerDeserializer.INSTANCE.serialize(Double.valueOf(val), out);
    }
}

