/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types.hierachy;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;
import org.apache.hyracks.data.std.primitive.FloatPointable;

public class FloatToInt8TypeConvertComputer
implements ITypeConvertComputer {
    public static final FloatToInt8TypeConvertComputer INSTANCE = new FloatToInt8TypeConvertComputer();

    private FloatToInt8TypeConvertComputer() {
    }

    @Override
    public void convertType(byte[] data, int start, int length, DataOutput out) throws IOException {
        float sourceValue = FloatPointable.getFloat((byte[])data, (int)start);
        if (sourceValue > 127.0f || sourceValue < -128.0f) {
            throw new IOException("Cannot convert Float to INT8 - Float value " + sourceValue + " is out of range that INT8 type can hold: INT8.MAX_VALUE:" + 127 + ", INT8.MIN_VALUE: " + -128);
        }
        byte targetValue = (byte)Math.floor(sourceValue);
        out.writeByte(ATypeTag.INT8.serialize());
        out.writeByte(targetValue);
    }
}

