/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types.hierachy;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;
import org.apache.hyracks.data.std.primitive.FloatPointable;

public class FloatToInt32TypeConvertComputer
implements ITypeConvertComputer {
    public static final FloatToInt32TypeConvertComputer INSTANCE = new FloatToInt32TypeConvertComputer();

    private FloatToInt32TypeConvertComputer() {
    }

    @Override
    public void convertType(byte[] data, int start, int length, DataOutput out) throws IOException {
        float sourceValue = FloatPointable.getFloat((byte[])data, (int)start);
        if (sourceValue > 2.1474836E9f || sourceValue < -2.1474836E9f) {
            throw new IOException("Cannot convert Float to INT32 - Float value " + sourceValue + " is out of range that INT32 type can hold: INT32.MAX_VALUE:" + Integer.MAX_VALUE + ", INT32.MIN_VALUE: " + Integer.MIN_VALUE);
        }
        int targetValue = (int)Math.floor(sourceValue);
        out.writeByte(ATypeTag.INT32.serialize());
        out.writeInt(targetValue);
    }
}

