/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types.hierachy;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;
import org.apache.hyracks.data.std.primitive.FloatPointable;

public class FloatToInt16TypeConvertComputer
implements ITypeConvertComputer {
    public static final FloatToInt16TypeConvertComputer INSTANCE = new FloatToInt16TypeConvertComputer();

    private FloatToInt16TypeConvertComputer() {
    }

    @Override
    public void convertType(byte[] data, int start, int length, DataOutput out) throws IOException {
        float sourceValue = FloatPointable.getFloat((byte[])data, (int)start);
        if (sourceValue > 32767.0f || sourceValue < -32768.0f) {
            throw new IOException("Cannot convert Float to INT16 - Float value " + sourceValue + " is out of range that INT16 type can hold: INT16.MAX_VALUE:" + Short.MAX_VALUE + ", INT16.MIN_VALUE: " + Short.MIN_VALUE);
        }
        short targetValue = (short)Math.floor(sourceValue);
        out.writeByte(ATypeTag.INT16.serialize());
        out.writeShort(targetValue);
    }
}

