/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types.hierachy;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;
import org.apache.hyracks.data.std.primitive.DoublePointable;

public class DoubleToInt32TypeConvertComputer
implements ITypeConvertComputer {
    public static final DoubleToInt32TypeConvertComputer INSTANCE = new DoubleToInt32TypeConvertComputer();

    private DoubleToInt32TypeConvertComputer() {
    }

    @Override
    public void convertType(byte[] data, int start, int length, DataOutput out) throws IOException {
        double sourceValue = DoublePointable.getDouble((byte[])data, (int)start);
        if (sourceValue > 2.147483647E9 || sourceValue < -2.147483648E9) {
            throw new IOException("Cannot convert Double to INT32 - Double value " + sourceValue + " is out of range that INT32 type can hold: INT32.MAX_VALUE:" + Integer.MAX_VALUE + ", INT32.MIN_VALUE: " + Integer.MIN_VALUE);
        }
        int targetValue = (int)Math.floor(sourceValue);
        out.writeByte(ATypeTag.INT32.serialize());
        out.writeInt(targetValue);
    }
}

