/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types.hierachy;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;
import org.apache.hyracks.data.std.primitive.DoublePointable;

public class DoubleToInt16TypeConvertComputer
implements ITypeConvertComputer {
    public static final DoubleToInt16TypeConvertComputer INSTANCE = new DoubleToInt16TypeConvertComputer();

    private DoubleToInt16TypeConvertComputer() {
    }

    @Override
    public void convertType(byte[] data, int start, int length, DataOutput out) throws IOException {
        double sourceValue = DoublePointable.getDouble((byte[])data, (int)start);
        if (sourceValue > 32767.0 || sourceValue < -32768.0) {
            throw new IOException("Cannot convert Double to INT16 - Double value " + sourceValue + " is out of range that INT16 type can hold: INT16.MAX_VALUE:" + Short.MAX_VALUE + ", INT16.MIN_VALUE: " + Short.MIN_VALUE);
        }
        short targetValue = (short)Math.floor(sourceValue);
        out.writeByte(ATypeTag.INT16.serialize());
        out.writeShort(targetValue);
    }
}

