/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types.hierachy;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;

public abstract class AbstractIntegerTypeConvertComputer
implements ITypeConvertComputer {
    public void convertIntegerType(byte[] data, int start, int length, DataOutput out, ATypeTag targetType, int targetTypeLength) throws IOException {
        long num = 0L;
        switch (length) {
            case 1: {
                num = data[start] & 0xFF;
                break;
            }
            case 2: {
                num = (short)(data[start] << 8 | data[start + 1] & 0xFF);
                break;
            }
            case 4: {
                num = (data[start] & 0xFF) << 24 | (data[start + 1] & 0xFF) << 16 | (data[start + 2] & 0xFF) << 8 | data[start + 3] & 0xFF;
                break;
            }
            case 8: {
                num = (long)(data[start] & 0xFF) << 56 | (long)(data[start + 1] & 0xFF) << 48 | (long)(data[start + 2] & 0xFF) << 40 | (long)(data[start + 3] & 0xFF) << 32 | (long)(data[start + 4] & 0xFF) << 24 | (long)(data[start + 5] & 0xFF) << 16 | (long)(data[start + 6] & 0xFF) << 8 | (long)(data[start + 7] & 0xFF);
                break;
            }
            default: {
                throw new IOException("Can't convert integer types. The source type should be one of INT8/16/32/64.");
            }
        }
        switch (targetType) {
            case INT8: {
                if (num <= 127L && num >= -128L) break;
                throw new IOException("Source value " + num + " is out of range that INT8 can hold - INT8.MAX_VALUE:" + 127 + ", INT8.MIN_VALUE:" + -128);
            }
            case INT16: {
                if (num <= 32767L && num >= -32768L) break;
                throw new IOException("Source value " + num + " is out of range that INT16 can hold - INT16.MAX_VALUE:" + Short.MAX_VALUE + ", INT16.MIN_VALUE:" + Short.MIN_VALUE);
            }
            case INT32: {
                if (num <= Integer.MAX_VALUE && num >= Integer.MIN_VALUE) break;
                throw new IOException("Source value " + num + " is out of range that INT32 can hold - INT32.MAX_VALUE:" + Integer.MAX_VALUE + ", INT32.MIN_VALUE:" + Integer.MIN_VALUE);
            }
        }
        out.writeByte(targetType.serialize());
        switch (targetTypeLength) {
            case 1: {
                out.writeByte((byte)(num & 0xFFL));
                break;
            }
            case 2: {
                out.writeByte((byte)(num >> 8 & 0xFFL));
                out.writeByte((byte)(num & 0xFFL));
                break;
            }
            case 4: {
                out.writeByte((byte)(num >> 24 & 0xFFL));
                out.writeByte((byte)(num >> 16 & 0xFFL));
                out.writeByte((byte)(num >> 8 & 0xFFL));
                out.writeByte((byte)(num & 0xFFL));
                break;
            }
            case 8: {
                out.writeByte((byte)(num >> 56 & 0xFFL));
                out.writeByte((byte)(num >> 48 & 0xFFL));
                out.writeByte((byte)(num >> 40 & 0xFFL));
                out.writeByte((byte)(num >> 32 & 0xFFL));
                out.writeByte((byte)(num >> 24 & 0xFFL));
                out.writeByte((byte)(num >> 16 & 0xFFL));
                out.writeByte((byte)(num >> 8 & 0xFFL));
                out.writeByte((byte)(num & 0xFFL));
                break;
            }
            default: {
                throw new IOException("Can't convert integer types. The target type should be one of INT8/16/32/64.");
            }
        }
    }
}

