/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types.hierachy;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.AFloat;
import org.apache.asterix.om.base.AInt16;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AInt8;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.hierachy.DoubleToFloatTypeConvertComputer;
import org.apache.asterix.om.types.hierachy.DoubleToInt16TypeConvertComputer;
import org.apache.asterix.om.types.hierachy.DoubleToInt32TypeConvertComputer;
import org.apache.asterix.om.types.hierachy.DoubleToInt64TypeConvertComputer;
import org.apache.asterix.om.types.hierachy.DoubleToInt8TypeConvertComputer;
import org.apache.asterix.om.types.hierachy.FloatToDoubleTypeConvertComputer;
import org.apache.asterix.om.types.hierachy.FloatToInt16TypeConvertComputer;
import org.apache.asterix.om.types.hierachy.FloatToInt32TypeConvertComputer;
import org.apache.asterix.om.types.hierachy.FloatToInt64TypeConvertComputer;
import org.apache.asterix.om.types.hierachy.FloatToInt8TypeConvertComputer;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;
import org.apache.asterix.om.types.hierachy.IntegerToDoubleTypeConvertComputer;
import org.apache.asterix.om.types.hierachy.IntegerToFloatTypeConvertComputer;
import org.apache.asterix.om.types.hierachy.IntegerToInt16TypeConvertComputer;
import org.apache.asterix.om.types.hierachy.IntegerToInt32TypeConvertComputer;
import org.apache.asterix.om.types.hierachy.IntegerToInt64TypeConvertComputer;
import org.apache.asterix.om.types.hierachy.IntegerToInt8TypeConvertComputer;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.DoublePointable;
import org.apache.hyracks.data.std.primitive.FloatPointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.LongPointable;
import org.apache.hyracks.data.std.primitive.ShortPointable;

public class ATypeHierarchy {
    private static BitSet typePromotionHierachyMap = new BitSet(ATypeTag.TYPE_COUNT * ATypeTag.TYPE_COUNT);
    private static BitSet typeDemotionHierachyMap = new BitSet(ATypeTag.TYPE_COUNT * ATypeTag.TYPE_COUNT);
    private static HashMap<Integer, ITypeConvertComputer> promoteComputerMap = new HashMap();
    private static HashMap<Integer, ITypeConvertComputer> demoteComputerMap = new HashMap();
    private static Map<ATypeTag, Domain> hierarchyDomains = new HashMap<ATypeTag, Domain>();
    private static ITypeConvertComputer convertComputer;

    public static Domain getTypeDomain(ATypeTag tag) {
        return hierarchyDomains.get(tag);
    }

    public static boolean isSameTypeDomain(ATypeTag tag1, ATypeTag tag2, boolean useListDomain) {
        Domain tagHierarchy1 = hierarchyDomains.get(tag1);
        Domain tagHierarchy2 = hierarchyDomains.get(tag2);
        if (tagHierarchy1 == null || tagHierarchy2 == null) {
            return false;
        }
        if (useListDomain && tagHierarchy1 == Domain.LIST && tagHierarchy2 == Domain.LIST) {
            return true;
        }
        return tagHierarchy1.equals((Object)tagHierarchy2) && !useListDomain;
    }

    public static void addPromotionRule(ATypeTag type1, ATypeTag type2, ITypeConvertComputer promoteComputer) {
        int index = type1.ordinal() * ATypeTag.TYPE_COUNT + type2.ordinal();
        typePromotionHierachyMap.set(index);
        promoteComputerMap.put(index, promoteComputer);
    }

    public static void addDemotionRule(ATypeTag type1, ATypeTag type2, ITypeConvertComputer demoteComputer) {
        int index = type1.ordinal() * ATypeTag.TYPE_COUNT + type2.ordinal();
        typeDemotionHierachyMap.set(index);
        demoteComputerMap.put(index, demoteComputer);
    }

    public static ITypeConvertComputer getTypePromoteComputer(ATypeTag type1, ATypeTag type2) {
        if (ATypeHierarchy.canPromote(type1, type2)) {
            return promoteComputerMap.get(type1.ordinal() * ATypeTag.TYPE_COUNT + type2.ordinal());
        }
        return null;
    }

    public static ITypeConvertComputer getTypeDemoteComputer(ATypeTag type1, ATypeTag type2) {
        if (ATypeHierarchy.canDemote(type1, type2)) {
            return demoteComputerMap.get(type1.ordinal() * ATypeTag.TYPE_COUNT + type2.ordinal());
        }
        return null;
    }

    public static boolean canPromote(ATypeTag type1, ATypeTag type2) {
        return typePromotionHierachyMap.get(type1.ordinal() * ATypeTag.TYPE_COUNT + type2.ordinal());
    }

    public static boolean canDemote(ATypeTag type1, ATypeTag type2) {
        return typeDemotionHierachyMap.get(type1.ordinal() * ATypeTag.TYPE_COUNT + type2.ordinal());
    }

    public static boolean isCompatible(ATypeTag type1, ATypeTag type2) {
        return type1 == ATypeTag.ANY || type2 == ATypeTag.ANY || ATypeHierarchy.canPromote(type1, type2) || ATypeHierarchy.canPromote(type2, type1);
    }

    public static AsterixConstantValue getAsterixConstantValueFromNumericTypeObject(IAObject sourceObject, ATypeTag targetTypeTag) throws AlgebricksException {
        ATypeTag sourceTypeTag = sourceObject.getType().getTypeTag();
        AsterixConstantValue asterixNewConstantValue = null;
        if (sourceTypeTag != targetTypeTag) {
            block0 : switch (targetTypeTag) {
                case INT64: {
                    switch (sourceTypeTag) {
                        case INT8: {
                            asterixNewConstantValue = new AsterixConstantValue(new AInt64(Long.valueOf(((AInt8)sourceObject).getByteValue())));
                            break block0;
                        }
                        case INT16: {
                            asterixNewConstantValue = new AsterixConstantValue(new AInt64(Long.valueOf(((AInt16)sourceObject).getShortValue())));
                            break block0;
                        }
                        case INT32: {
                            asterixNewConstantValue = new AsterixConstantValue(new AInt64((long)((AInt32)sourceObject).getIntegerValue()));
                            break block0;
                        }
                        case FLOAT: {
                            float tmpFloatValue = ((AFloat)sourceObject).getFloatValue();
                            ATypeHierarchy.valueSanitycheck(ATypeTag.FLOAT, ATypeTag.INT64, tmpFloatValue);
                            asterixNewConstantValue = new AsterixConstantValue(new AInt64((long)tmpFloatValue));
                            break block0;
                        }
                        case DOUBLE: {
                            double tmpDoubleValue = ((ADouble)sourceObject).getDoubleValue();
                            ATypeHierarchy.valueSanitycheck(ATypeTag.DOUBLE, ATypeTag.INT64, tmpDoubleValue);
                            asterixNewConstantValue = new AsterixConstantValue(new AInt64((long)tmpDoubleValue));
                            break block0;
                        }
                    }
                    break;
                }
                case INT32: {
                    switch (sourceTypeTag) {
                        case INT8: {
                            asterixNewConstantValue = new AsterixConstantValue(new AInt32(((AInt8)sourceObject).getByteValue()));
                            break block0;
                        }
                        case INT16: {
                            asterixNewConstantValue = new AsterixConstantValue(new AInt32(((AInt16)sourceObject).getShortValue()));
                            break block0;
                        }
                        case INT64: {
                            long tmpLongValue = ((AInt64)sourceObject).getLongValue();
                            ATypeHierarchy.valueSanitycheck(ATypeTag.INT64, ATypeTag.INT32, tmpLongValue);
                            asterixNewConstantValue = new AsterixConstantValue(new AInt32((int)tmpLongValue));
                            break block0;
                        }
                        case FLOAT: {
                            float tmpFloatValue = ((AFloat)sourceObject).getFloatValue();
                            ATypeHierarchy.valueSanitycheck(ATypeTag.FLOAT, ATypeTag.INT32, tmpFloatValue);
                            asterixNewConstantValue = new AsterixConstantValue(new AInt32((int)tmpFloatValue));
                            break block0;
                        }
                        case DOUBLE: {
                            double tmpDoubleValue = ((ADouble)sourceObject).getDoubleValue();
                            ATypeHierarchy.valueSanitycheck(ATypeTag.FLOAT, ATypeTag.INT32, tmpDoubleValue);
                            asterixNewConstantValue = new AsterixConstantValue(new AInt32((int)tmpDoubleValue));
                            break block0;
                        }
                    }
                    break;
                }
                case INT8: {
                    switch (sourceTypeTag) {
                        case INT16: {
                            short tmpShortValue = ((AInt16)sourceObject).getShortValue();
                            ATypeHierarchy.valueSanitycheck(ATypeTag.INT16, ATypeTag.INT8, tmpShortValue);
                            asterixNewConstantValue = new AsterixConstantValue(new AInt8((byte)tmpShortValue));
                            break block0;
                        }
                        case INT32: {
                            int tmpIntValue = ((AInt32)sourceObject).getIntegerValue();
                            ATypeHierarchy.valueSanitycheck(ATypeTag.INT32, ATypeTag.INT8, tmpIntValue);
                            asterixNewConstantValue = new AsterixConstantValue(new AInt8((byte)tmpIntValue));
                            break block0;
                        }
                        case INT64: {
                            long tmpLongValue = ((AInt64)sourceObject).getLongValue();
                            ATypeHierarchy.valueSanitycheck(ATypeTag.INT64, ATypeTag.INT8, tmpLongValue);
                            asterixNewConstantValue = new AsterixConstantValue(new AInt8((byte)tmpLongValue));
                            break block0;
                        }
                        case FLOAT: {
                            float tmpFloatValue = ((AFloat)sourceObject).getFloatValue();
                            ATypeHierarchy.valueSanitycheck(ATypeTag.FLOAT, ATypeTag.INT8, tmpFloatValue);
                            asterixNewConstantValue = new AsterixConstantValue(new AInt8((byte)tmpFloatValue));
                            break block0;
                        }
                        case DOUBLE: {
                            double tmpDoubleValue = ((ADouble)sourceObject).getDoubleValue();
                            ATypeHierarchy.valueSanitycheck(ATypeTag.DOUBLE, ATypeTag.INT8, tmpDoubleValue);
                            asterixNewConstantValue = new AsterixConstantValue(new AInt8((byte)tmpDoubleValue));
                            break block0;
                        }
                    }
                    break;
                }
                case INT16: {
                    switch (sourceTypeTag) {
                        case INT8: {
                            asterixNewConstantValue = new AsterixConstantValue(new AInt16(((AInt8)sourceObject).getByteValue()));
                            break block0;
                        }
                        case INT32: {
                            int tmpIntValue = ((AInt32)sourceObject).getIntegerValue();
                            ATypeHierarchy.valueSanitycheck(ATypeTag.INT32, ATypeTag.INT16, tmpIntValue);
                            asterixNewConstantValue = new AsterixConstantValue(new AInt16((short)tmpIntValue));
                            break block0;
                        }
                        case INT64: {
                            long tmpLongValue = ((AInt64)sourceObject).getLongValue();
                            ATypeHierarchy.valueSanitycheck(ATypeTag.INT64, ATypeTag.INT16, tmpLongValue);
                            asterixNewConstantValue = new AsterixConstantValue(new AInt16((short)tmpLongValue));
                            break block0;
                        }
                        case FLOAT: {
                            float tmpFloatValue = ((AFloat)sourceObject).getFloatValue();
                            ATypeHierarchy.valueSanitycheck(ATypeTag.FLOAT, ATypeTag.INT16, tmpFloatValue);
                            asterixNewConstantValue = new AsterixConstantValue(new AInt16((short)tmpFloatValue));
                            break block0;
                        }
                        case DOUBLE: {
                            double tmpDoubleValue = ((ADouble)sourceObject).getDoubleValue();
                            ATypeHierarchy.valueSanitycheck(ATypeTag.DOUBLE, ATypeTag.INT16, tmpDoubleValue);
                            asterixNewConstantValue = new AsterixConstantValue(new AInt16((short)tmpDoubleValue));
                            break block0;
                        }
                    }
                    break;
                }
                case FLOAT: {
                    switch (sourceTypeTag) {
                        case INT8: {
                            asterixNewConstantValue = new AsterixConstantValue(new AFloat(((AInt8)sourceObject).getByteValue()));
                            break block0;
                        }
                        case INT16: {
                            asterixNewConstantValue = new AsterixConstantValue(new AFloat(((AInt16)sourceObject).getShortValue()));
                            break block0;
                        }
                        case INT32: {
                            asterixNewConstantValue = new AsterixConstantValue(new AFloat(((AInt32)sourceObject).getIntegerValue().intValue()));
                            break block0;
                        }
                        case INT64: {
                            asterixNewConstantValue = new AsterixConstantValue(new AFloat(((AInt64)sourceObject).getLongValue()));
                            break block0;
                        }
                        case DOUBLE: {
                            double tmpDoubleValue = ((ADouble)sourceObject).getDoubleValue();
                            ATypeHierarchy.valueSanitycheck(ATypeTag.DOUBLE, ATypeTag.FLOAT, tmpDoubleValue);
                            asterixNewConstantValue = new AsterixConstantValue(new AFloat((float)tmpDoubleValue));
                            break block0;
                        }
                    }
                    break;
                }
                case DOUBLE: {
                    switch (sourceTypeTag) {
                        case INT8: {
                            asterixNewConstantValue = new AsterixConstantValue(new ADouble(((AInt8)sourceObject).getByteValue()));
                            break block0;
                        }
                        case INT16: {
                            asterixNewConstantValue = new AsterixConstantValue(new ADouble(((AInt16)sourceObject).getShortValue()));
                            break block0;
                        }
                        case INT32: {
                            asterixNewConstantValue = new AsterixConstantValue(new ADouble(((AInt32)sourceObject).getIntegerValue().intValue()));
                            break block0;
                        }
                        case INT64: {
                            asterixNewConstantValue = new AsterixConstantValue(new ADouble(((AInt64)sourceObject).getLongValue()));
                            break block0;
                        }
                        case FLOAT: {
                            asterixNewConstantValue = new AsterixConstantValue(new ADouble(((AFloat)sourceObject).getFloatValue()));
                            break block0;
                        }
                    }
                    break;
                }
            }
            return asterixNewConstantValue;
        }
        return new AsterixConstantValue(sourceObject);
    }

    private static void valueSanitycheck(ATypeTag sourceType, ATypeTag targetType, double sourceValue) throws AlgebricksException {
        boolean canConvert = true;
        switch (targetType) {
            case INT8: {
                if (!(sourceValue > 127.0) && !(sourceValue < -128.0)) break;
                canConvert = false;
                break;
            }
            case INT16: {
                if (!(sourceValue > 32767.0) && !(sourceValue < -32768.0)) break;
                canConvert = false;
                break;
            }
            case INT32: {
                if (!(sourceValue > 2.147483647E9) && !(sourceValue < -2.147483648E9)) break;
                canConvert = false;
                break;
            }
            case INT64: {
                if (!(sourceValue > 9.223372036854776E18) && !(sourceValue < -9.223372036854776E18)) break;
                canConvert = false;
                break;
            }
            case FLOAT: {
                if (!(sourceValue > 3.4028234663852886E38) && !(sourceValue < (double)1.4E-45f)) break;
                canConvert = false;
                break;
            }
        }
        if (!canConvert) {
            throw new AlgebricksException("Can't cast a value: " + sourceValue + " from " + sourceType + " type to " + targetType + " type because of the out-of-range error.");
        }
    }

    public static IAObject convertNumericTypeObject(IAObject sourceObject, ATypeTag targetTypeTag) throws AsterixException {
        ATypeTag sourceTypeTag = sourceObject.getType().getTypeTag();
        switch (sourceTypeTag) {
            case INT8: {
                switch (targetTypeTag) {
                    case INT8: {
                        return sourceObject;
                    }
                    case INT16: {
                        return new AInt16(((AInt8)sourceObject).getByteValue());
                    }
                    case INT32: {
                        return new AInt32(((AInt8)sourceObject).getByteValue());
                    }
                    case INT64: {
                        return new AInt64(Long.valueOf(((AInt8)sourceObject).getByteValue()));
                    }
                    case FLOAT: {
                        return new AFloat(((AInt8)sourceObject).getByteValue());
                    }
                    case DOUBLE: {
                        return new ADouble(((AInt8)sourceObject).getByteValue());
                    }
                }
                throw new AsterixException("Can't convert the " + sourceTypeTag + " type to the " + targetTypeTag + " type.");
            }
            case INT16: {
                switch (targetTypeTag) {
                    case INT8: {
                        return new AInt8((byte)((AInt16)sourceObject).getShortValue());
                    }
                    case INT16: {
                        return sourceObject;
                    }
                    case INT32: {
                        return new AInt32(((AInt16)sourceObject).getShortValue());
                    }
                    case INT64: {
                        return new AInt64(Long.valueOf(((AInt16)sourceObject).getShortValue()));
                    }
                    case FLOAT: {
                        return new AFloat(((AInt16)sourceObject).getShortValue());
                    }
                    case DOUBLE: {
                        return new ADouble(((AInt16)sourceObject).getShortValue());
                    }
                }
                throw new AsterixException("Can't convert the " + sourceTypeTag + " type to the " + targetTypeTag + " type.");
            }
            case INT32: {
                switch (targetTypeTag) {
                    case INT8: {
                        return new AInt8(((AInt32)sourceObject).getIntegerValue().byteValue());
                    }
                    case INT16: {
                        return new AInt16(((AInt32)sourceObject).getIntegerValue().shortValue());
                    }
                    case INT32: {
                        return sourceObject;
                    }
                    case INT64: {
                        return new AInt64((long)((AInt32)sourceObject).getIntegerValue());
                    }
                    case FLOAT: {
                        return new AFloat(((AInt32)sourceObject).getIntegerValue().intValue());
                    }
                    case DOUBLE: {
                        return new ADouble(((AInt32)sourceObject).getIntegerValue().intValue());
                    }
                }
                throw new AsterixException("Can't convert the " + sourceTypeTag + " type to the " + targetTypeTag + " type.");
            }
            case INT64: {
                switch (targetTypeTag) {
                    case INT8: {
                        return new AInt8((byte)((AInt64)sourceObject).getLongValue());
                    }
                    case INT16: {
                        return new AInt16((short)((AInt64)sourceObject).getLongValue());
                    }
                    case INT32: {
                        return new AInt32((int)((AInt64)sourceObject).getLongValue());
                    }
                    case INT64: {
                        return sourceObject;
                    }
                    case FLOAT: {
                        return new AFloat(((AInt64)sourceObject).getLongValue());
                    }
                    case DOUBLE: {
                        return new ADouble(((AInt64)sourceObject).getLongValue());
                    }
                }
                throw new AsterixException("Can't convert the " + sourceTypeTag + " type to the " + targetTypeTag + " type.");
            }
            case FLOAT: {
                switch (targetTypeTag) {
                    case INT8: {
                        return new AInt8((byte)((AFloat)sourceObject).getFloatValue());
                    }
                    case INT16: {
                        return new AInt16((short)((AFloat)sourceObject).getFloatValue());
                    }
                    case INT32: {
                        return new AInt32((int)((AFloat)sourceObject).getFloatValue());
                    }
                    case INT64: {
                        return new AInt64((long)((AFloat)sourceObject).getFloatValue());
                    }
                    case FLOAT: {
                        return sourceObject;
                    }
                    case DOUBLE: {
                        return new ADouble(((AFloat)sourceObject).getFloatValue());
                    }
                }
                throw new AsterixException("Can't convert the " + sourceTypeTag + " type to the " + targetTypeTag + " type.");
            }
            case DOUBLE: {
                switch (targetTypeTag) {
                    case INT8: {
                        return new AInt8((byte)((ADouble)sourceObject).getDoubleValue());
                    }
                    case INT16: {
                        return new AInt16((short)((ADouble)sourceObject).getDoubleValue());
                    }
                    case INT32: {
                        return new AInt32((int)((ADouble)sourceObject).getDoubleValue());
                    }
                    case INT64: {
                        return new AInt64((long)((ADouble)sourceObject).getDoubleValue());
                    }
                    case FLOAT: {
                        return new AFloat((float)((ADouble)sourceObject).getDoubleValue());
                    }
                    case DOUBLE: {
                        return sourceObject;
                    }
                }
                throw new AsterixException("Can't convert the " + sourceTypeTag + " type to the " + targetTypeTag + " type.");
            }
        }
        throw new AsterixException("Source type is not a numeric type.");
    }

    public static void convertNumericTypeByteArray(byte[] sourceByteArray, int s1, int l1, ATypeTag targetTypeTag, DataOutput out) throws AsterixException, IOException {
        ATypeTag sourceTypeTag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(sourceByteArray[s1]);
        if (sourceTypeTag != targetTypeTag) {
            if (ATypeHierarchy.canPromote(sourceTypeTag, targetTypeTag)) {
                convertComputer = ATypeHierarchy.getTypePromoteComputer(sourceTypeTag, targetTypeTag);
                convertComputer.convertType(sourceByteArray, s1 + 1, l1 - 1, out);
            } else if (ATypeHierarchy.canDemote(sourceTypeTag, targetTypeTag)) {
                convertComputer = ATypeHierarchy.getTypeDemoteComputer(sourceTypeTag, targetTypeTag);
                convertComputer.convertType(sourceByteArray, s1 + 1, l1 - 1, out);
            } else {
                throw new IOException("Can't convert the " + sourceTypeTag + " type to the " + targetTypeTag + " type.");
            }
        }
    }

    public static int getIntegerValue(String name, int argIndex, byte[] bytes, int offset) throws HyracksDataException {
        return ATypeHierarchy.getIntegerValueWithDifferentTypeTagPosition(name, argIndex, bytes, offset + 1, offset);
    }

    public static int getIntegerValueWithDifferentTypeTagPosition(String name, int argIndex, byte[] bytes, int offset, int typeTagPosition) throws HyracksDataException {
        int value;
        ATypeTag sourceTypeTag = ATypeTag.VALUE_TYPE_MAPPING[bytes[typeTagPosition]];
        if (sourceTypeTag == null) {
            throw new RuntimeDataException(6, new Serializable[]{name, Integer.valueOf(argIndex)});
        }
        switch (sourceTypeTag) {
            case INT64: {
                value = (int)LongPointable.getLong((byte[])bytes, (int)offset);
                break;
            }
            case INT32: {
                value = IntegerPointable.getInteger((byte[])bytes, (int)offset);
                break;
            }
            case INT8: {
                value = bytes[offset];
                break;
            }
            case INT16: {
                value = ShortPointable.getShort((byte[])bytes, (int)offset);
                break;
            }
            case FLOAT: {
                value = (int)FloatPointable.getFloat((byte[])bytes, (int)offset);
                break;
            }
            case DOUBLE: {
                value = (int)DoublePointable.getDouble((byte[])bytes, (int)offset);
                break;
            }
            default: {
                throw new RuntimeDataException(2, new Serializable[]{name, Integer.valueOf(argIndex), sourceTypeTag, ATypeTag.INT8, ATypeTag.INT16, ATypeTag.INT32, ATypeTag.INT64, ATypeTag.FLOAT, ATypeTag.DOUBLE});
            }
        }
        return value;
    }

    public static long getLongValue(String name, int argIndex, byte[] bytes, int offset) throws HyracksDataException {
        return ATypeHierarchy.getLongValueWithDifferentTypeTagPosition(name, argIndex, bytes, offset + 1, offset);
    }

    private static long getLongValueWithDifferentTypeTagPosition(String name, int argIndex, byte[] bytes, int offset, int typeTagPosition) throws HyracksDataException {
        long value;
        ATypeTag sourceTypeTag = ATypeTag.VALUE_TYPE_MAPPING[bytes[typeTagPosition]];
        if (sourceTypeTag == null) {
            throw new RuntimeDataException(6, new Serializable[]{name, Integer.valueOf(argIndex)});
        }
        switch (sourceTypeTag) {
            case INT64: {
                value = LongPointable.getLong((byte[])bytes, (int)offset);
                break;
            }
            case INT32: {
                value = IntegerPointable.getInteger((byte[])bytes, (int)offset);
                break;
            }
            case INT8: {
                value = bytes[offset];
                break;
            }
            case INT16: {
                value = ShortPointable.getShort((byte[])bytes, (int)offset);
                break;
            }
            case FLOAT: {
                value = (long)FloatPointable.getFloat((byte[])bytes, (int)offset);
                break;
            }
            case DOUBLE: {
                value = (long)DoublePointable.getDouble((byte[])bytes, (int)offset);
                break;
            }
            default: {
                throw new RuntimeDataException(2, new Serializable[]{name, Integer.valueOf(argIndex), sourceTypeTag, ATypeTag.INT8, ATypeTag.INT16, ATypeTag.INT32, ATypeTag.INT64, ATypeTag.FLOAT, ATypeTag.DOUBLE});
            }
        }
        return value;
    }

    public static double getDoubleValue(String name, int argIndex, byte[] bytes, int offset) throws HyracksDataException {
        return ATypeHierarchy.getDoubleValueWithDifferentTypeTagPosition(name, argIndex, bytes, offset + 1, offset);
    }

    private static double getDoubleValueWithDifferentTypeTagPosition(String name, int argIndex, byte[] bytes, int offset, int typeTagPosition) throws HyracksDataException {
        double value;
        ATypeTag sourceTypeTag = ATypeTag.VALUE_TYPE_MAPPING[bytes[typeTagPosition]];
        if (sourceTypeTag == null) {
            throw new RuntimeDataException(6, new Serializable[]{name, Integer.valueOf(argIndex)});
        }
        switch (sourceTypeTag) {
            case INT64: {
                value = LongPointable.getLong((byte[])bytes, (int)offset);
                break;
            }
            case INT32: {
                value = IntegerPointable.getInteger((byte[])bytes, (int)offset);
                break;
            }
            case INT8: {
                value = bytes[offset];
                break;
            }
            case INT16: {
                value = ShortPointable.getShort((byte[])bytes, (int)offset);
                break;
            }
            case FLOAT: {
                value = FloatPointable.getFloat((byte[])bytes, (int)offset);
                break;
            }
            case DOUBLE: {
                value = DoublePointable.getDouble((byte[])bytes, (int)offset);
                break;
            }
            default: {
                throw new RuntimeDataException(2, new Serializable[]{name, Integer.valueOf(argIndex), sourceTypeTag, ATypeTag.INT8, ATypeTag.INT16, ATypeTag.INT32, ATypeTag.INT64, ATypeTag.FLOAT, ATypeTag.DOUBLE});
            }
        }
        return value;
    }

    static {
        for (int i = 0; i < ATypeTag.TYPE_COUNT; ++i) {
            typePromotionHierachyMap.set(i * ATypeTag.TYPE_COUNT + i);
            typeDemotionHierachyMap.set(i * ATypeTag.TYPE_COUNT + i);
        }
        ATypeHierarchy.addPromotionRule(ATypeTag.INT8, ATypeTag.INT16, IntegerToInt16TypeConvertComputer.INSTANCE);
        ATypeHierarchy.addPromotionRule(ATypeTag.INT8, ATypeTag.INT32, IntegerToInt32TypeConvertComputer.INSTANCE);
        ATypeHierarchy.addPromotionRule(ATypeTag.INT8, ATypeTag.INT64, IntegerToInt64TypeConvertComputer.INSTANCE);
        ATypeHierarchy.addPromotionRule(ATypeTag.INT16, ATypeTag.INT32, IntegerToInt32TypeConvertComputer.INSTANCE);
        ATypeHierarchy.addPromotionRule(ATypeTag.INT16, ATypeTag.INT64, IntegerToInt64TypeConvertComputer.INSTANCE);
        ATypeHierarchy.addPromotionRule(ATypeTag.INT32, ATypeTag.INT64, IntegerToInt64TypeConvertComputer.INSTANCE);
        ATypeHierarchy.addPromotionRule(ATypeTag.INT8, ATypeTag.DOUBLE, IntegerToDoubleTypeConvertComputer.INSTANCE);
        ATypeHierarchy.addPromotionRule(ATypeTag.INT16, ATypeTag.DOUBLE, IntegerToDoubleTypeConvertComputer.INSTANCE);
        ATypeHierarchy.addPromotionRule(ATypeTag.INT32, ATypeTag.DOUBLE, IntegerToDoubleTypeConvertComputer.INSTANCE);
        ATypeHierarchy.addPromotionRule(ATypeTag.INT64, ATypeTag.DOUBLE, IntegerToDoubleTypeConvertComputer.INSTANCE);
        ATypeHierarchy.addPromotionRule(ATypeTag.FLOAT, ATypeTag.DOUBLE, FloatToDoubleTypeConvertComputer.INSTANCE);
        ATypeHierarchy.addPromotionRule(ATypeTag.INT8, ATypeTag.FLOAT, IntegerToFloatTypeConvertComputer.INSTANCE);
        ATypeHierarchy.addPromotionRule(ATypeTag.INT16, ATypeTag.FLOAT, IntegerToFloatTypeConvertComputer.INSTANCE);
        ATypeHierarchy.addPromotionRule(ATypeTag.INT32, ATypeTag.FLOAT, IntegerToFloatTypeConvertComputer.INSTANCE);
        ATypeHierarchy.addPromotionRule(ATypeTag.INT64, ATypeTag.FLOAT, IntegerToFloatTypeConvertComputer.INSTANCE);
        ATypeHierarchy.addDemotionRule(ATypeTag.INT16, ATypeTag.INT8, IntegerToInt8TypeConvertComputer.INSTANCE);
        ATypeHierarchy.addDemotionRule(ATypeTag.INT32, ATypeTag.INT8, IntegerToInt8TypeConvertComputer.INSTANCE);
        ATypeHierarchy.addDemotionRule(ATypeTag.INT64, ATypeTag.INT8, IntegerToInt8TypeConvertComputer.INSTANCE);
        ATypeHierarchy.addDemotionRule(ATypeTag.INT32, ATypeTag.INT16, IntegerToInt16TypeConvertComputer.INSTANCE);
        ATypeHierarchy.addDemotionRule(ATypeTag.INT64, ATypeTag.INT16, IntegerToInt16TypeConvertComputer.INSTANCE);
        ATypeHierarchy.addDemotionRule(ATypeTag.INT64, ATypeTag.INT32, IntegerToInt32TypeConvertComputer.INSTANCE);
        ATypeHierarchy.addDemotionRule(ATypeTag.FLOAT, ATypeTag.INT8, FloatToInt8TypeConvertComputer.INSTANCE);
        ATypeHierarchy.addDemotionRule(ATypeTag.FLOAT, ATypeTag.INT16, FloatToInt16TypeConvertComputer.INSTANCE);
        ATypeHierarchy.addDemotionRule(ATypeTag.FLOAT, ATypeTag.INT32, FloatToInt32TypeConvertComputer.INSTANCE);
        ATypeHierarchy.addDemotionRule(ATypeTag.FLOAT, ATypeTag.INT64, FloatToInt64TypeConvertComputer.INSTANCE);
        ATypeHierarchy.addDemotionRule(ATypeTag.DOUBLE, ATypeTag.INT8, DoubleToInt8TypeConvertComputer.INSTANCE);
        ATypeHierarchy.addDemotionRule(ATypeTag.DOUBLE, ATypeTag.INT16, DoubleToInt16TypeConvertComputer.INSTANCE);
        ATypeHierarchy.addDemotionRule(ATypeTag.DOUBLE, ATypeTag.INT32, DoubleToInt32TypeConvertComputer.INSTANCE);
        ATypeHierarchy.addDemotionRule(ATypeTag.DOUBLE, ATypeTag.INT64, DoubleToInt64TypeConvertComputer.INSTANCE);
        ATypeHierarchy.addDemotionRule(ATypeTag.DOUBLE, ATypeTag.FLOAT, DoubleToFloatTypeConvertComputer.INSTANCE);
        hierarchyDomains.put(ATypeTag.POINT, Domain.SPATIAL);
        hierarchyDomains.put(ATypeTag.LINE, Domain.SPATIAL);
        hierarchyDomains.put(ATypeTag.CIRCLE, Domain.SPATIAL);
        hierarchyDomains.put(ATypeTag.POLYGON, Domain.SPATIAL);
        hierarchyDomains.put(ATypeTag.RECTANGLE, Domain.SPATIAL);
        hierarchyDomains.put(ATypeTag.INT8, Domain.NUMERIC);
        hierarchyDomains.put(ATypeTag.INT16, Domain.NUMERIC);
        hierarchyDomains.put(ATypeTag.INT32, Domain.NUMERIC);
        hierarchyDomains.put(ATypeTag.INT64, Domain.NUMERIC);
        hierarchyDomains.put(ATypeTag.FLOAT, Domain.NUMERIC);
        hierarchyDomains.put(ATypeTag.DOUBLE, Domain.NUMERIC);
        hierarchyDomains.put(ATypeTag.ORDEREDLIST, Domain.LIST);
        hierarchyDomains.put(ATypeTag.UNORDEREDLIST, Domain.LIST);
    }

    public static enum Domain {
        SPATIAL,
        NUMERIC,
        LIST,
        ANY;

    }
}

