/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.IAType;

public class AUnorderedListType
extends AbstractCollectionType {
    private static final long serialVersionUID = 1L;
    public static final AUnorderedListType FULLY_OPEN_UNORDEREDLIST_TYPE = new AUnorderedListType(null, "");

    public AUnorderedListType(IAType itemType, String typeName) {
        super(itemType, typeName);
    }

    @Override
    public ATypeTag getTypeTag() {
        return ATypeTag.UNORDEREDLIST;
    }

    @Override
    public String getDisplayName() {
        return "AUnorderedList";
    }

    public String toString() {
        return "{{ " + this.itemType + " }}";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AUnorderedListType) {
            AUnorderedListType type = (AUnorderedListType)obj;
            return this.itemType.equals(type.itemType);
        }
        return false;
    }

    public int hashCode() {
        return this.itemType.hashCode() * 10;
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        return this.equals(obj);
    }

    @Override
    public int hash() {
        return this.hashCode();
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode type = om.createObjectNode();
        type.put("type", AUnorderedListType.class.getName());
        type.set("item-type", (JsonNode)this.itemType.toJSON());
        return type;
    }
}

