/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import org.apache.asterix.om.exceptions.TypeMismatchException;
import org.apache.asterix.om.typecomputer.base.AbstractResultTypeComputer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;

public class NumericRound2TypeComputer
extends AbstractResultTypeComputer {
    public static final NumericRound2TypeComputer INSTANCE = new NumericRound2TypeComputer();

    private NumericRound2TypeComputer() {
    }

    @Override
    protected void checkArgType(String funcName, int argIndex, IAType type) throws AlgebricksException {
        ATypeTag tag = type.getTypeTag();
        if (argIndex == 0) {
            switch (tag) {
                case INT8: 
                case INT16: 
                case INT32: 
                case INT64: 
                case FLOAT: 
                case DOUBLE: {
                    break;
                }
                default: {
                    throw new TypeMismatchException(funcName, (Integer)argIndex, tag, ATypeTag.INT8, ATypeTag.INT16, ATypeTag.INT32, ATypeTag.INT64, ATypeTag.FLOAT, ATypeTag.DOUBLE);
                }
            }
        }
        if (argIndex == 1) {
            switch (tag) {
                case INT8: 
                case INT16: 
                case INT32: 
                case INT64: {
                    break;
                }
                default: {
                    throw new TypeMismatchException(funcName, (Integer)argIndex, tag, ATypeTag.INT8, ATypeTag.INT16, ATypeTag.INT32, ATypeTag.INT64);
                }
            }
        }
    }

    @Override
    protected IAType getResultType(ILogicalExpression expr, IAType ... strippedInputTypes) throws AlgebricksException {
        ATypeTag tag = strippedInputTypes[0].getTypeTag();
        switch (tag) {
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: 
            case ANY: {
                return strippedInputTypes[0];
            }
        }
        return null;
    }
}

