/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.pointables.printer;

import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.om.pointables.AFlatValuePointable;
import org.apache.asterix.om.pointables.AListVisitablePointable;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.pointables.printer.AListPrinter;
import org.apache.asterix.om.pointables.printer.ARecordPrinter;
import org.apache.asterix.om.pointables.printer.IPrintVisitor;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public abstract class AbstractPrintVisitor
implements IPrintVisitor {
    private final Map<IVisitablePointable, ARecordPrinter> raccessorToPrinter = new HashMap<IVisitablePointable, ARecordPrinter>();
    private final Map<IVisitablePointable, AListPrinter> laccessorToPrinter = new HashMap<IVisitablePointable, AListPrinter>();

    @Override
    public Void visit(AListVisitablePointable accessor, Pair<PrintStream, ATypeTag> arg) throws AsterixException {
        AListPrinter printer = this.laccessorToPrinter.get(accessor);
        if (printer == null) {
            printer = this.createListPrinter(accessor);
            this.laccessorToPrinter.put(accessor, printer);
        }
        try {
            printer.printList(accessor, (PrintStream)arg.first, this);
        }
        catch (IOException e) {
            throw new AsterixException((Throwable)e);
        }
        return null;
    }

    @Override
    public Void visit(ARecordVisitablePointable accessor, Pair<PrintStream, ATypeTag> arg) throws AsterixException {
        ARecordPrinter printer = this.raccessorToPrinter.get(accessor);
        if (printer == null) {
            printer = this.createRecordPrinter(accessor);
            this.raccessorToPrinter.put(accessor, printer);
        }
        try {
            printer.printRecord(accessor, (PrintStream)arg.first, this);
        }
        catch (IOException e) {
            throw new AsterixException((Throwable)e);
        }
        return null;
    }

    @Override
    public Void visit(AFlatValuePointable accessor, Pair<PrintStream, ATypeTag> arg) throws AsterixException {
        try {
            byte[] b = accessor.getByteArray();
            int s = accessor.getStartOffset();
            int l = accessor.getLength();
            PrintStream ps = (PrintStream)arg.first;
            ATypeTag typeTag = (ATypeTag)arg.second;
            if (!this.printFlatValue(typeTag, b, s, l, ps)) {
                throw new AsterixException("No printer for type " + typeTag);
            }
            return null;
        }
        catch (HyracksDataException e) {
            throw new AsterixException((Throwable)e);
        }
    }

    protected abstract AListPrinter createListPrinter(AListVisitablePointable var1) throws AsterixException;

    protected abstract ARecordPrinter createRecordPrinter(ARecordVisitablePointable var1) throws AsterixException;

    protected abstract boolean printFlatValue(ATypeTag var1, byte[] var2, int var3, int var4, PrintStream var5) throws HyracksDataException;
}

