/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.visitors.IOMVisitor;

public class ShortWithoutTypeInfo
implements IAObject {
    protected short value;

    public ShortWithoutTypeInfo(short value) {
        this.value = value;
    }

    public ShortWithoutTypeInfo(byte[] bytes, int offset, int length) {
        this.value = ShortWithoutTypeInfo.valueFromBytes(bytes, offset, length);
    }

    public Short getShortValue() {
        return this.value;
    }

    @Override
    public IAType getType() {
        return BuiltinType.SHORTWITHOUTTYPEINFO;
    }

    public String toString() {
        return "ShortWithoutTypeInfo: {" + this.value + "}";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShortWithoutTypeInfo)) {
            return false;
        }
        return this.value == ((ShortWithoutTypeInfo)obj).getShortValue();
    }

    public int hashCode() {
        return this.value;
    }

    private static short valueFromBytes(byte[] bytes, int offset, int length) {
        return (short)(((bytes[offset] & 0xFF) << 8) + (bytes[offset + 1] & 0xFF));
    }

    public byte[] toBytes() {
        return new byte[]{(byte)(this.value >>> 8 & 0xFF), (byte)(this.value >>> 0 & 0xFF)};
    }

    @Override
    public void accept(IOMVisitor visitor) throws AsterixException {
        visitor.visitShortWithoutTypeInfo(this);
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        return this.equals(obj);
    }

    @Override
    public int hash() {
        return this.hashCode();
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        json.put("ShortWithoutTypeInfo", this.value);
        return json;
    }
}

