/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.visitors.IOMVisitor;

public class ATime
implements IAObject {
    protected int chrononTime;

    public ATime(int chrononTime) {
        this.chrononTime = chrononTime;
    }

    @Override
    public IAType getType() {
        return BuiltinType.ATIME;
    }

    public int compare(Object o) {
        if (!(o instanceof ATime)) {
            return -1;
        }
        ATime d = (ATime)o;
        if (this.chrononTime > d.chrononTime) {
            return 1;
        }
        if (this.chrononTime < d.chrononTime) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ATime)) {
            return false;
        }
        ATime t = (ATime)o;
        return t.chrononTime == this.chrononTime;
    }

    public int hashCode() {
        return this.chrononTime;
    }

    @Override
    public void accept(IOMVisitor visitor) throws AsterixException {
        visitor.visitATime(this);
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        return this.equals(obj);
    }

    @Override
    public int hash() {
        return this.hashCode();
    }

    public String toString() {
        StringBuilder sbder = new StringBuilder();
        sbder.append("ATime: { ");
        try {
            GregorianCalendarSystem.getInstance().getExtendStringRepUntilField(this.chrononTime, 0, sbder, GregorianCalendarSystem.Fields.HOUR, GregorianCalendarSystem.Fields.MILLISECOND, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        sbder.append(" }");
        return sbder.toString();
    }

    public int getChrononTime() {
        return this.chrononTime;
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        json.put("ATime", this.chrononTime);
        return json;
    }
}

