/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.base.InMemUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.asterix.om.visitors.IOMVisitor;

public class ARecord
implements IAObject {
    public static final ARecord EMPTY_OPEN_RECORD = new ARecord(RecordUtil.FULLY_OPEN_RECORD_TYPE, new IAObject[0]);
    protected ARecordType type;
    protected IAObject[] fields;

    public ARecord(ARecordType type, IAObject[] fields) {
        this.type = type;
        this.fields = fields;
    }

    @Override
    public void accept(IOMVisitor visitor) throws AsterixException {
        visitor.visitARecord(this);
    }

    @Override
    public ARecordType getType() {
        return this.type;
    }

    public boolean isOpen() {
        return this.type.isOpen();
    }

    public IAObject getValueByPos(int pos) {
        return this.fields[pos];
    }

    public int numberOfFields() {
        return this.fields.length;
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        return this.equals(obj);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ARecord)) {
            return false;
        }
        ARecord r = (ARecord)obj;
        if (!this.type.deepEqual(r.type)) {
            return false;
        }
        return InMemUtils.deepEqualArrays(this.fields, r.fields);
    }

    @Override
    public int hash() {
        int h = 0;
        for (int i = 0; i < this.fields.length; ++i) {
            h += 31 * h + this.fields[i].hash();
        }
        return h;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ARecord: { ");
        if (this.fields != null) {
            for (int i = 0; i < this.fields.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.type.getFieldNames()[i]);
                sb.append(": ");
                sb.append(this.fields[i]);
            }
        }
        sb.append(" }");
        return sb.toString();
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        ArrayNode record = om.createArrayNode();
        for (int i = 0; i < this.fields.length; ++i) {
            ObjectNode item = om.createObjectNode();
            item.set(this.type.getFieldNames()[i], (JsonNode)this.fields[i].toJSON());
            record.add((JsonNode)item);
        }
        json.set("ARecord", (JsonNode)record);
        return json;
    }
}

