/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.om.base.ACollectionCursor;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IACollection;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.base.InMemUtils;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.visitors.IOMVisitor;

public class AOrderedList
implements IACollection {
    protected List<IAObject> values;
    protected AOrderedListType type;

    public AOrderedList(AOrderedListType type) {
        this.values = new ArrayList<IAObject>();
        this.type = type;
    }

    public AOrderedList(AOrderedListType type, List<IAObject> sequence) {
        this.values = sequence;
        this.type = type;
    }

    public AOrderedList(List<String> sequence) {
        this.values = new ArrayList<IAObject>();
        for (int i = 0; i < sequence.size(); ++i) {
            this.values.add(new AString(sequence.get(i)));
        }
        this.type = new AOrderedListType(BuiltinType.ASTRING, null);
    }

    public void add(IAObject obj) {
        this.values.add(obj);
    }

    @Override
    public IACursor getCursor() {
        ACollectionCursor cursor = new ACollectionCursor();
        cursor.reset(this);
        return cursor;
    }

    @Override
    public IAType getType() {
        return this.type;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AOrderedList)) {
            return false;
        }
        AOrderedList y = (AOrderedList)o;
        return InMemUtils.cursorEquals(this.getCursor(), y.getCursor());
    }

    public int hashCode() {
        return InMemUtils.hashCursor(this.getCursor());
    }

    public IAObject getItem(int index) {
        return this.values.get(index);
    }

    @Override
    public void accept(IOMVisitor visitor) throws AsterixException {
        visitor.visitAOrderedList(this);
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        return this.equals(obj);
    }

    @Override
    public int hash() {
        return this.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AOrderedList: [ ");
        boolean first = true;
        for (IAObject v : this.values) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(v.toString());
        }
        sb.append(" ]");
        return sb.toString();
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        ArrayNode list = om.createArrayNode();
        for (IAObject v : this.values) {
            list.add((JsonNode)v.toJSON());
        }
        json.set("AOrderedList", (JsonNode)list);
        return json;
    }
}

