/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.visitors.IOMVisitor;

public class AInt8
implements IAObject {
    protected byte value;

    public AInt8(Byte value) {
        this.value = value;
    }

    @Override
    public void accept(IOMVisitor visitor) throws AsterixException {
        visitor.visitAInt8(this);
    }

    @Override
    public IAType getType() {
        return BuiltinType.AINT8;
    }

    public byte getByteValue() {
        return this.value;
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        if (!(obj instanceof AInt8)) {
            return false;
        }
        return this.value == ((AInt8)obj).getByteValue();
    }

    @Override
    public int hash() {
        return this.value;
    }

    public String toString() {
        return "AInt8: {" + this.value + "}";
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        json.put("AInt8", (short)this.value);
        return json;
    }
}

