/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.visitors.IOMVisitor;

public class AInt32
implements IAObject {
    protected int value;

    public AInt32(int value) {
        this.value = value;
    }

    public AInt32(byte[] bytes, int offset, int length) {
        this.value = AInt32.valueFromBytes(bytes, offset, length);
    }

    public Integer getIntegerValue() {
        return this.value;
    }

    @Override
    public IAType getType() {
        return BuiltinType.AINT32;
    }

    public String toString() {
        return "AInt32: {" + this.value + "}";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AInt32)) {
            return false;
        }
        return this.value == ((AInt32)obj).getIntegerValue();
    }

    public int hashCode() {
        return this.value;
    }

    private static Integer valueFromBytes(byte[] bytes, int offset, int length) {
        return ((bytes[offset] & 0xFF) << 24) + ((bytes[offset + 1] & 0xFF) << 16) + ((bytes[offset + 2] & 0xFF) << 8) + ((bytes[offset + 3] & 0xFF) << 0);
    }

    public byte[] toBytes() {
        return new byte[]{(byte)(this.value >>> 24), (byte)(this.value >> 16 & 0xFF), (byte)(this.value >> 8 & 0xFF), (byte)(this.value & 0xFF)};
    }

    @Override
    public void accept(IOMVisitor visitor) throws AsterixException {
        visitor.visitAInt32(this);
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        return this.equals(obj);
    }

    @Override
    public int hash() {
        return this.hashCode();
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        json.put("AInt32", this.value);
        return json;
    }
}

