/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.formats.nontagged;

import org.apache.asterix.formats.nontagged.TypeTrait;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.data.ITypeTraitProvider;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;

public class TypeTraitProvider
implements ITypeTraitProvider {
    private static final ITypeTraits ONEBYTETYPETRAIT = new TypeTrait(2);
    private static final ITypeTraits TWOBYTETYPETRAIT = new TypeTrait(3);
    private static final ITypeTraits FOURBYTETYPETRAIT = new TypeTrait(5);
    private static final ITypeTraits EIGHTBYTETYPETRAIT = new TypeTrait(9);
    private static final ITypeTraits SIXTEENBYTETYPETRAIT = new TypeTrait(17);
    private static final ITypeTraits SEVENTEENBYTETYPETRAIT = new TypeTrait(18);
    private static final ITypeTraits THIRTYTWOBYTETYPETRAIT = new TypeTrait(33);
    private static final ITypeTraits TWENTYFOURBYTETYPETRAIT = new TypeTrait(25);
    private static final ITypeTraits VARLENTYPETRAIT = new TypeTrait(false, -1);
    public static final TypeTraitProvider INSTANCE = new TypeTraitProvider();

    public ITypeTraits getTypeTrait(Object type) {
        IAType aqlType = (IAType)type;
        if (aqlType == null) {
            return null;
        }
        switch (aqlType.getTypeTag()) {
            case BOOLEAN: 
            case INT8: {
                return ONEBYTETYPETRAIT;
            }
            case INT16: {
                return TWOBYTETYPETRAIT;
            }
            case INT32: 
            case FLOAT: 
            case DATE: 
            case TIME: {
                return FOURBYTETYPETRAIT;
            }
            case INT64: 
            case DOUBLE: 
            case DATETIME: 
            case DURATION: {
                return EIGHTBYTETYPETRAIT;
            }
            case POINT: 
            case UUID: {
                return SIXTEENBYTETYPETRAIT;
            }
            case INTERVAL: {
                return SEVENTEENBYTETYPETRAIT;
            }
            case POINT3D: {
                return TWENTYFOURBYTETYPETRAIT;
            }
            case LINE: {
                return THIRTYTWOBYTETYPETRAIT;
            }
        }
        return VARLENTYPETRAIT;
    }
}

