/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.formats.nontagged;

import java.io.Serializable;
import org.apache.asterix.dataflow.data.nontagged.comparators.ABinaryComparator;
import org.apache.asterix.dataflow.data.nontagged.comparators.ACirclePartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.ADurationPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.AIntervalAscPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.AIntervalDescPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.ALinePartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.AObjectAscBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.AObjectDescBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.APoint3DPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.APointPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.APolygonPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.ARectanglePartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.AUUIDPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.BooleanBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.RawBinaryComparatorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.data.IBinaryComparatorFactoryProvider;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.accessors.PointableBinaryComparatorFactory;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.primitive.ByteArrayPointable;
import org.apache.hyracks.data.std.primitive.BytePointable;
import org.apache.hyracks.data.std.primitive.DoublePointable;
import org.apache.hyracks.data.std.primitive.FloatPointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.LongPointable;
import org.apache.hyracks.data.std.primitive.ShortPointable;
import org.apache.hyracks.data.std.primitive.UTF8StringLowercasePointable;
import org.apache.hyracks.data.std.primitive.UTF8StringLowercaseTokenPointable;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;

public class BinaryComparatorFactoryProvider
implements IBinaryComparatorFactoryProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final BinaryComparatorFactoryProvider INSTANCE = new BinaryComparatorFactoryProvider();
    public static final PointableBinaryComparatorFactory BYTE_POINTABLE_INSTANCE = new PointableBinaryComparatorFactory(BytePointable.FACTORY);
    public static final PointableBinaryComparatorFactory SHORT_POINTABLE_INSTANCE = new PointableBinaryComparatorFactory(ShortPointable.FACTORY);
    public static final PointableBinaryComparatorFactory INTEGER_POINTABLE_INSTANCE = new PointableBinaryComparatorFactory(IntegerPointable.FACTORY);
    public static final PointableBinaryComparatorFactory LONG_POINTABLE_INSTANCE = new PointableBinaryComparatorFactory((IPointableFactory)LongPointable.FACTORY);
    public static final PointableBinaryComparatorFactory FLOAT_POINTABLE_INSTANCE = new PointableBinaryComparatorFactory(FloatPointable.FACTORY);
    public static final PointableBinaryComparatorFactory DOUBLE_POINTABLE_INSTANCE = new PointableBinaryComparatorFactory(DoublePointable.FACTORY);
    public static final PointableBinaryComparatorFactory UTF8STRING_POINTABLE_INSTANCE = new PointableBinaryComparatorFactory(UTF8StringPointable.FACTORY);
    public static final PointableBinaryComparatorFactory UTF8STRING_LOWERCASE_POINTABLE_INSTANCE = new PointableBinaryComparatorFactory(UTF8StringLowercasePointable.FACTORY);
    public static final PointableBinaryComparatorFactory UTF8STRING_LOWERCASE_TOKEN_POINTABLE_INSTANCE = new PointableBinaryComparatorFactory(UTF8StringLowercaseTokenPointable.FACTORY);
    public static final PointableBinaryComparatorFactory BINARY_POINTABLE_INSTANCE = new PointableBinaryComparatorFactory(ByteArrayPointable.FACTORY);

    private BinaryComparatorFactoryProvider() {
    }

    public IBinaryComparatorFactory getBinaryComparatorFactory(Object type, boolean ascending, boolean ignoreCase) {
        if (type == null) {
            return this.anyBinaryComparatorFactory(ascending);
        }
        IAType aqlType = (IAType)type;
        if (aqlType.getTypeTag() == ATypeTag.STRING && ignoreCase) {
            return this.addOffset((IBinaryComparatorFactory)UTF8STRING_LOWERCASE_POINTABLE_INSTANCE, ascending);
        }
        return this.getBinaryComparatorFactory(type, ascending);
    }

    public IBinaryComparatorFactory getBinaryComparatorFactory(Object type, boolean ascending) {
        return this.anyBinaryComparatorFactory(ascending);
    }

    public IBinaryComparatorFactory getBinaryComparatorFactory(ATypeTag type, boolean ascending) {
        switch (type) {
            case ANY: 
            case UNION: {
                return this.anyBinaryComparatorFactory(ascending);
            }
            case NULL: 
            case MISSING: {
                return new IBinaryComparatorFactory(){
                    private static final long serialVersionUID = 1L;

                    public IBinaryComparator createBinaryComparator() {
                        return new IBinaryComparator(){

                            public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
                                return 0;
                            }
                        };
                    }
                };
            }
            case BOOLEAN: {
                return this.addOffset(BooleanBinaryComparatorFactory.INSTANCE, ascending);
            }
            case INT8: {
                return this.addOffset((IBinaryComparatorFactory)BYTE_POINTABLE_INSTANCE, ascending);
            }
            case INT16: {
                return this.addOffset((IBinaryComparatorFactory)SHORT_POINTABLE_INSTANCE, ascending);
            }
            case DATE: 
            case TIME: 
            case YEARMONTHDURATION: 
            case INT32: {
                return this.addOffset((IBinaryComparatorFactory)INTEGER_POINTABLE_INSTANCE, ascending);
            }
            case DATETIME: 
            case DAYTIMEDURATION: 
            case INT64: {
                return this.addOffset((IBinaryComparatorFactory)LONG_POINTABLE_INSTANCE, ascending);
            }
            case FLOAT: {
                return this.addOffset((IBinaryComparatorFactory)FLOAT_POINTABLE_INSTANCE, ascending);
            }
            case DOUBLE: {
                return this.addOffset((IBinaryComparatorFactory)DOUBLE_POINTABLE_INSTANCE, ascending);
            }
            case STRING: {
                return this.addOffset((IBinaryComparatorFactory)UTF8STRING_POINTABLE_INSTANCE, ascending);
            }
            case RECTANGLE: {
                return this.addOffset(ARectanglePartialBinaryComparatorFactory.INSTANCE, ascending);
            }
            case CIRCLE: {
                return this.addOffset(ACirclePartialBinaryComparatorFactory.INSTANCE, ascending);
            }
            case POINT: {
                return this.addOffset(APointPartialBinaryComparatorFactory.INSTANCE, ascending);
            }
            case POINT3D: {
                return this.addOffset(APoint3DPartialBinaryComparatorFactory.INSTANCE, ascending);
            }
            case LINE: {
                return this.addOffset(ALinePartialBinaryComparatorFactory.INSTANCE, ascending);
            }
            case POLYGON: {
                return this.addOffset(APolygonPartialBinaryComparatorFactory.INSTANCE, ascending);
            }
            case DURATION: {
                return this.addOffset(ADurationPartialBinaryComparatorFactory.INSTANCE, ascending);
            }
            case INTERVAL: {
                return this.addOffset(this.intervalBinaryComparatorFactory(ascending), ascending);
            }
            case UUID: {
                return this.addOffset(AUUIDPartialBinaryComparatorFactory.INSTANCE, ascending);
            }
            case BINARY: {
                return this.addOffset((IBinaryComparatorFactory)BINARY_POINTABLE_INSTANCE, ascending);
            }
        }
        return this.addOffset(RawBinaryComparatorFactory.INSTANCE, ascending);
    }

    private IBinaryComparatorFactory addOffset(final IBinaryComparatorFactory inst, final boolean ascending) {
        return new IBinaryComparatorFactory(){
            private static final long serialVersionUID = 1L;

            public IBinaryComparator createBinaryComparator() {
                final IBinaryComparator bc = inst.createBinaryComparator();
                if (ascending) {
                    return new ABinaryComparator(){

                        @Override
                        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) throws HyracksDataException {
                            return bc.compare(b1, s1 + 1, l1 - 1, b2, s2 + 1, l2 - 1);
                        }
                    };
                }
                return new ABinaryComparator(){

                    @Override
                    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) throws HyracksDataException {
                        return -bc.compare(b1, s1 + 1, l1 - 1, b2, s2 + 1, l2 - 1);
                    }
                };
            }
        };
    }

    private IBinaryComparatorFactory anyBinaryComparatorFactory(boolean ascending) {
        if (ascending) {
            return AObjectAscBinaryComparatorFactory.INSTANCE;
        }
        return AObjectDescBinaryComparatorFactory.INSTANCE;
    }

    private IBinaryComparatorFactory intervalBinaryComparatorFactory(boolean ascending) {
        if (ascending) {
            return AIntervalAscPartialBinaryComparatorFactory.INSTANCE;
        }
        return AIntervalDescPartialBinaryComparatorFactory.INSTANCE;
    }
}

